/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.math.BigInteger;
import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;

public class Power
extends AbstractArg2
implements INumeric {
    public static final Power CONST = new Power();
    static final IAST RULES = F.List(F.Set(F.Power((IExpr)F.E, F.Times((IExpr)F.CI, (IExpr)F.Pi)), F.CN1), F.SetDelayed(F.Power((IExpr)F.E, F.Log(F.$p("x"))), F.$s("x")), F.SetDelayed(F.Power((IExpr)F.Tan(F.$p("x")), F.$p("n", (IExpr)F.$s("IntegerQ"))), F.Condition(F.Power((IExpr)F.Cot(F.$s("x")), F.Times((IExpr)F.CN1, (IExpr)F.$s("n"))), F.Less(F.$s("n"), F.C0))), F.SetDelayed(F.Power((IExpr)F.Cot(F.$p("x")), F.$p("n", (IExpr)F.$s("IntegerQ"))), F.Condition(F.Power((IExpr)F.Tan(F.$s("x")), F.Times((IExpr)F.CN1, (IExpr)F.$s("n"))), F.Less(F.$s("n"), F.C0))), F.SetDelayed(F.Power((IExpr)F.Sec(F.$p("x")), F.$p("n", (IExpr)F.$s("IntegerQ"))), F.Condition(F.Power((IExpr)F.Cos(F.$s("x")), F.Times((IExpr)F.CN1, (IExpr)F.$s("n"))), F.Less(F.$s("n"), F.C0))), F.SetDelayed(F.Power((IExpr)F.Cos(F.$p("x")), F.$p("n", (IExpr)F.$s("IntegerQ"))), F.Condition(F.Power((IExpr)F.Sec(F.$s("x")), F.Times((IExpr)F.CN1, (IExpr)F.$s("n"))), F.Less(F.$s("n"), F.C0))), F.SetDelayed(F.Power((IExpr)F.Csc(F.$p("x")), F.$p("n", (IExpr)F.$s("IntegerQ"))), F.Condition(F.Power((IExpr)F.Sin(F.$s("x")), F.Times((IExpr)F.CN1, (IExpr)F.$s("n"))), F.Less(F.$s("n"), F.C0))), F.SetDelayed(F.Power((IExpr)F.Sin(F.$p("x")), F.$p("n", (IExpr)F.$s("IntegerQ"))), F.Condition(F.Power((IExpr)F.Csc(F.$s("x")), F.Times((IExpr)F.CN1, (IExpr)F.$s("n"))), F.Less(F.$s("n"), F.C0))));

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr e2DblComArg(IComplexNum c0, IComplexNum c1) {
        return c0.pow(c1);
    }

    @Override
    public IExpr e2ComArg(IComplex c0, IComplex c1) {
        return null;
    }

    @Override
    public IExpr e2DblArg(INum d0, INum d1) {
        if (d1.isMinusOne()) {
            return d0.inverse();
        }
        if (d1.isNumIntValue()) {
            return d0.pow(d1);
        }
        if (d0.isNegative()) {
            return F.complexNum(d0.doubleValue()).pow(F.complexNum(d1.doubleValue()));
        }
        return d0.pow(d1);
    }

    @Override
    public IExpr e2IntArg(IInteger i0, IInteger i1) {
        if (i0.equals(F.C0)) {
            return null;
        }
        if (i1.isNegative()) {
            return F.fraction(F.C1, i0.pow(((IInteger)i1.negate()).getBigNumerator().intValue()));
        }
        return i0.pow(i1.getBigNumerator().intValue());
    }

    @Override
    public IExpr e2ObjArg(IExpr o0, IExpr o1) {
        if (o0.equals(F.Indeterminate) || o1.equals(F.Indeterminate)) {
            return F.Indeterminate;
        }
        if (o0.isZero()) {
            EvalEngine ee = EvalEngine.get();
            if (o1.isZero()) {
                if (!ee.isQuietMode()) {
                    ee.getOutPrintStream().println("Infinite expression 0^0");
                }
                return F.Indeterminate;
            }
            if (o1.isSignedNumber() && ((ISignedNumber)o1).isNegative()) {
                if (!ee.isQuietMode()) {
                    ee.getOutPrintStream().println("Infinite expression 0^(negative number)");
                }
                return F.CComplexInfinity;
            }
            return F.C0;
        }
        if (o1.isZero()) {
            return F.C1;
        }
        if (o1.isOne()) {
            return o0;
        }
        if (o0.isOne()) {
            return F.C1;
        }
        if (o1.isSignedNumber()) {
            ISignedNumber is = (ISignedNumber)o1;
            if (o0.isInfinity()) {
                if (is.isNegative()) {
                    return F.C0;
                }
                return F.CInfinity;
            }
            if (o0.isNegativeInfinity() && o1.isInteger()) {
                IInteger ii = (IInteger)o1;
                if (ii.isNegative()) {
                    return F.C0;
                }
                if (ii.isOdd()) {
                    return F.CNInfinity;
                }
                return F.CInfinity;
            }
        }
        if (o1.isMinusOne() && o0.isNumber()) {
            return ((INumber)o0).inverse();
        }
        if (o0.isSignedNumber() && ((ISignedNumber)o0).isNegative() && o1.equals(F.C1D2)) {
            return F.Times((IExpr)F.CI, (IExpr)F.Power((IExpr)F.Times((IExpr)F.CN1, o0), o1));
        }
        if (o0.isAST()) {
            IAST arg0 = (IAST)o0;
            if (arg0.isTimes()) {
                IAST f0;
                if (o1.isInteger()) {
                    return arg0.map(Functors.replace1st(F.Power((IExpr)F.Null, o1)));
                }
                if (o1.isNumber() && (f0 = arg0).size() > 1 && f0.arg1().isNumber()) {
                    return F.Times((IExpr)F.Power(f0.arg1(), o1), (IExpr)F.Power((IExpr)F.ast(f0, F.Times, true, 2, f0.size()), o1));
                }
            }
            if (arg0.isPower() && o1.isInteger()) {
                return F.Power(arg0.arg1(), F.Times(o1, arg0.arg2()));
            }
        }
        return null;
    }

    @Override
    public IExpr e2FraArg(IFraction f0, IFraction f1) {
        int iNumer;
        if (f0.getNumerator().equals(F.C0)) {
            return F.C0;
        }
        if (f1.getNumerator().equals(F.C0)) {
            return F.C1;
        }
        if (f1.equals(F.C1D2) && f0.isNegative()) {
            return F.Times((IExpr)F.CI, (IExpr)F.Power((IExpr)f0.negate(), f1));
        }
        if (f1.equals(F.CN1D2) && f0.isNegative()) {
            return F.Times(F.CN1, F.CI, F.Power((IExpr)f0.negate().inverse(), f1.negate()));
        }
        if (!f1.getDenominator().equals(F.C1)) {
            IInteger b;
            IInteger a;
            IFraction f0Temp = f0;
            if (f0.sign() < 0) {
                f0Temp = (IFraction)f0Temp.negate();
            }
            if (f1.isNegative()) {
                a = f0Temp.getDenominator();
                b = f0Temp.getNumerator();
            } else {
                a = f0Temp.getNumerator();
                b = f0Temp.getDenominator();
            }
            if (!f1.getNumerator().equals(F.C1)) {
                try {
                    int exp = f1.getNumerator().toInt();
                    if (exp < 0) {
                        exp *= -1;
                    }
                    a = a.pow(exp);
                    b = b.pow(exp);
                }
                catch (ArithmeticException e) {
                    return null;
                }
            }
            IInteger root = f1.getDenominator();
            IInteger[] new_numer = this.calculateRoot(a, root);
            IInteger[] new_denom = this.calculateRoot(b, root);
            IFraction new_root = F.fraction(F.C1, root);
            if (new_numer != null) {
                if (new_denom != null) {
                    IRational p0 = null;
                    p0 = new_denom[1].equals(F.C1) ? new_numer[1] : F.fraction(new_numer[1], new_denom[1]);
                    if (f0.sign() < 0) {
                        return F.Times((IExpr)F.fraction(new_numer[0], new_denom[0]), (IExpr)F.Power((IExpr)p0.negate(), new_root));
                    }
                    return F.Times((IExpr)F.fraction(new_numer[0], new_denom[0]), (IExpr)F.Power((IExpr)p0, new_root));
                }
                if (a.equals(F.C1)) {
                    return null;
                }
                IRational p0 = null;
                p0 = b.equals(F.C1) ? new_numer[1] : F.fraction(new_numer[1], b);
                if (f0.sign() < 0) {
                    return F.Times((IExpr)new_numer[0], (IExpr)F.Power((IExpr)p0.negate(), new_root));
                }
                return F.Times((IExpr)new_numer[0], (IExpr)F.Power((IExpr)p0, new_root));
            }
            if (new_denom != null) {
                if (b.equals(F.C1)) {
                    return null;
                }
                IRational p0 = null;
                p0 = new_denom[1].equals(F.C1) ? a : F.fraction(a, new_denom[1]);
                if (f0.sign() < 0) {
                    return F.Times((IExpr)F.fraction(F.C1, new_denom[0]), (IExpr)F.Power((IExpr)p0.negate(), new_root));
                }
                return F.Times((IExpr)F.fraction(F.C1, new_denom[0]), (IExpr)F.Power((IExpr)p0, new_root));
            }
            return null;
        }
        try {
            iNumer = f1.getNumerator().toInt();
        }
        catch (ArithmeticException iob) {
            return null;
        }
        return f0.pow(iNumer);
    }

    private IInteger[] calculateRoot(IInteger a, IInteger root) {
        try {
            IInteger[] result = new IInteger[2];
            int n = root.toInt();
            if (n > 0) {
                if (a.equals(F.C1)) {
                    return null;
                }
                if (a.equals(F.CN1)) {
                    return null;
                }
                result = a.nthRootSplit(n);
                if (result[1].equals(a)) {
                    return null;
                }
                return result;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public IExpr eComIntArg(IComplex c0, IInteger i1) {
        if (c0.isZero()) {
            return F.C0;
        }
        if (i1.isZero()) {
            return F.C1;
        }
        return c0.pow(i1.getBigNumerator().intValue());
    }

    @Override
    public IExpr eComFraArg(IComplex c0, IFraction i1) {
        if (i1.equals(F.C1D2) && c0.getRealPart().equals((Object)BigFraction.ZERO)) {
            BigFraction im = c0.getImaginaryPart();
            boolean negative = false;
            if (NumberUtil.isNegative(im = im.divide(BigInteger.valueOf(2L)))) {
                im = im.negate();
                negative = true;
            }
            if (NumberUtil.isPerfectSquare(im)) {
                IAST temp = F.Sqrt(F.fraction(im));
                if (negative) {
                    return F.Plus((IExpr)temp, (IExpr)F.Times((IExpr)F.CNI, (IExpr)temp));
                }
                return F.Plus((IExpr)temp, (IExpr)F.Times((IExpr)F.CI, (IExpr)temp));
            }
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 2) {
            throw new UnsupportedOperationException();
        }
        return Math.pow(stack[top - 1], stack[top]);
    }
}

