/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.GenPolynomial;
import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.Factor;

public class PolynomialGCD
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        ExprVariables eVar = new ExprVariables(ast.arg1());
        if (!eVar.isSize(1)) {
            return null;
        }
        IExpr expr = F.evalExpandAll(ast.arg1());
        if (ast.size() > 3 && ast.last().isRuleAST()) {
            return this.gcdWithOption(ast, expr, eVar);
        }
        try {
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            JASConvert jas = new JASConvert((List<? extends IExpr>)r.toList(), BigRational.ZERO);
            GenPolynomial poly = jas.expr2JAS(expr);
            for (int i = 2; i < ast.size(); ++i) {
                eVar = new ExprVariables((IExpr)ast.get(i));
                if (!eVar.isSize(1)) {
                    return null;
                }
                expr = F.evalExpandAll((IExpr)ast.get(i));
                GenPolynomial temp = jas.expr2JAS(expr);
                poly = poly.gcd(temp);
            }
            return jas.rationalPoly2Expr(poly);
        }
        catch (JASConversionException e) {
            return null;
        }
    }

    private IExpr gcdWithOption(IAST ast, IExpr expr, ExprVariables eVar) {
        Options options = new Options(ast.topHead(), ast, ast.size() - 1);
        IExpr option = options.getOption("Modulus");
        if (option != null && option.isSignedNumber()) {
            return this.modulusGCD(ast, expr, eVar, option);
        }
        return null;
    }

    private IExpr modulusGCD(IAST ast, IExpr expr, ExprVariables eVar, IExpr option) {
        try {
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
            JASModInteger jas = new JASModInteger(r.toList(), modIntegerRing);
            GenPolynomial poly = jas.expr2JAS(expr);
            for (int i = 2; i < ast.size() - 1; ++i) {
                eVar = new ExprVariables((IExpr)ast.get(i));
                if (!eVar.isSize(1)) {
                    return null;
                }
                expr = F.evalExpandAll((IExpr)ast.get(i));
                GenPolynomial<ModLong> temp = jas.expr2JAS(expr);
                poly = poly.gcd(temp);
            }
            return Factor.factorModulus(jas, modIntegerRing, poly, false);
        }
        catch (JASConversionException e) {
            return null;
        }
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(96);
    }
}

