/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractArg12;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexUtils;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Log
extends AbstractArg12
implements INumeric {
    static final IAST RULES = F.List(F.Set(F.Log(F.Power((IExpr)F.E, F.Times((IExpr)F.CN1, (IExpr)F.CI))), F.Times((IExpr)F.CN1, (IExpr)F.CI)), F.Set(F.Log(F.Power((IExpr)F.E, F.CI)), F.CI), F.Set(F.Log(F.C0), F.Times((IExpr)F.CN1, (IExpr)F.CInfinity)), F.Set(F.Log(F.C1), F.C0), F.Set(F.Log(F.E), F.C1), F.SetDelayed(F.Log(F.Power((IExpr)F.E, F.$p("x", (IExpr)F.$s("Integer")))), F.$s("x")), F.SetDelayed(F.Log(F.Power((IExpr)F.E, F.$p("x", (IExpr)F.$s("Rational")))), F.$s("x")));

    @Override
    public IAST getRuleAST() {
        return RULES;
    }

    @Override
    public IExpr e1DblArg(INum arg1) {
        return Num.valueOf(Math.log(arg1.getRealPart()));
    }

    @Override
    public IExpr e1DblComArg(IComplexNum arg1) {
        return ComplexUtils.log((ComplexNum)arg1);
    }

    @Override
    public IExpr e2DblArg(INum arg1, INum arg2) {
        return Num.valueOf(Math.log(arg2.getRealPart()) / Math.log(arg1.getRealPart()));
    }

    @Override
    public IExpr e2IntArg(IInteger arg1, IInteger arg2) {
        try {
            int r;
            long l1 = arg1.toLong();
            long l2 = arg2.toLong();
            double res = Math.log(l2) / Math.log(l1);
            if (F.isNumIntValue(res) && arg2.equals(arg1.pow(r = Double.valueOf(Math.round(res)).intValue()))) {
                return F.integer(r);
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return Math.log(stack[top]);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }

    @Override
    public IExpr e1ObjArg(IExpr arg1) {
        IExpr temp;
        if (AbstractFunctionEvaluator.isNegativeExpression(arg1) && (temp = F.eval(F.Times((IExpr)F.CN1, arg1))).isPositive()) {
            return F.Plus((IExpr)F.Log(temp), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Pi));
        }
        return null;
    }
}

