/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.combinatoric.KPartitionsIterable;
import org.matheclipse.core.generic.combinatoric.KPermutationsIterable;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.ISymbol;

public class KOrderlessPartitions
extends AbstractFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 3);
        if (ast.arg1().isAST() && ast.arg2().isInteger()) {
            IAST listArg0 = (IAST)ast.arg1();
            ISymbol sym = listArg0.topHead();
            int n = listArg0.size() - 1;
            int k = ((IInteger)ast.arg2()).getBigNumerator().intValue();
            IAST result = F.ast(F.List);
            KPermutationsIterable permutationIterator = new KPermutationsIterable(listArg0, n, 1);
            KPartitionsIterable partitionIterator = new KPartitionsIterable(n, k);
            for (int[] permutationsIndex : permutationIterator) {
                for (int[] partitionsIndex : partitionIterator) {
                    IAST partition = this.createSinglePartition(listArg0, sym, permutationsIndex, partitionsIndex);
                    if (partition == null) continue;
                    result.add(partition);
                }
                partitionIterator.reset();
            }
            return result;
        }
        return null;
    }

    private IAST createSinglePartition(IAST listArg0, ISymbol sym, int[] permutationsIndex, int[] partitionsIndex) {
        IAST partitionElement;
        IAST partition = F.List();
        int n = listArg0.size() - 1;
        int partitionStartIndex = 0;
        for (int i = 1; i < partitionsIndex.length; ++i) {
            partitionElement = F.ast(sym);
            if (partitionStartIndex + 1 == partitionsIndex[i]) {
                if ((sym.getAttributes() & 1) == 1) {
                    partition.add(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                } else {
                    partitionElement.add(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                    partition.add(partitionElement);
                }
            } else {
                for (int m = partitionStartIndex; m < partitionsIndex[i]; ++m) {
                    if (m + 1 < partitionsIndex[i] && ((IExpr)listArg0.get(permutationsIndex[m + 1] + 1)).isLTOrdered((IExpr)listArg0.get(permutationsIndex[m] + 1))) {
                        return null;
                    }
                    partitionElement.add(listArg0.get(permutationsIndex[m] + 1));
                }
                partition.add(partitionElement);
            }
            partitionStartIndex = partitionsIndex[i];
        }
        partitionElement = F.ast(sym);
        if (partitionStartIndex + 1 == n) {
            if ((sym.getAttributes() & 1) == 1) {
                partition.add(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
            } else {
                partitionElement.add(listArg0.get(permutationsIndex[partitionStartIndex] + 1));
                partition.add(partitionElement);
            }
        } else {
            for (int m = partitionStartIndex; m < n; ++m) {
                if (m + 1 < n && ((IExpr)listArg0.get(permutationsIndex[m + 1] + 1)).isLTOrdered((IExpr)listArg0.get(permutationsIndex[m] + 1))) {
                    return null;
                }
                partitionElement.add(listArg0.get(permutationsIndex[m] + 1));
            }
            partition.add(partitionElement);
        }
        return partition;
    }
}

