/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.apache.commons.math3.fraction.BigFraction;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class HarmonicNumber
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkSize(ast, 2);
        IExpr arg1 = ast.arg1();
        if (arg1.isInteger()) {
            int n = Validate.checkIntType(ast, 1, Integer.MIN_VALUE);
            if (n < 0) {
                return null;
            }
            if (n == 0) {
                return F.C0;
            }
            if (n == 1) {
                return F.C1;
            }
            return F.fraction(this.harmonicNumber(n));
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    public BigFraction harmonicNumber(int n) {
        if (n < 1) {
            return new BigFraction(0, 1);
        }
        BigFraction a = new BigFraction(1, 1);
        for (int i = 2; i <= n; ++i) {
            a = a.add(new BigFraction(1, i));
        }
        return a;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(128);
    }
}

