/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import java.util.List;
import org.matheclipse.core.convert.ExprVariables;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.expression.ASTRange;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.reflection.system.Factor;

public class FactorSquareFree
extends Factor {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 2, 3);
        ExprVariables eVar = new ExprVariables(ast.arg1());
        if (!eVar.isSize(1)) {
            throw new WrongArgumentType(ast, ast.arg1(), 1, "Factorization only implemented for univariate polynomials");
        }
        try {
            IExpr expr = F.evalExpandAll(ast.arg1());
            ASTRange r = new ASTRange(eVar.getVarList(), 1);
            List<IExpr> varList = r.toList();
            if (ast.size() == 3) {
                return FactorSquareFree.factorWithOption(ast, expr, varList, true);
            }
            return FactorSquareFree.factor(expr, varList, true);
        }
        catch (JASConversionException jASConversionException) {
            return null;
        }
    }
}

