/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class EuclidianDistance
implements IFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        int dim2;
        Validate.checkSize(ast, 3);
        IExpr arg1 = ast.arg1();
        IExpr arg2 = ast.arg2();
        int dim1 = arg1.isVector();
        if (dim1 > -1 && dim1 == (dim2 = arg2.isVector())) {
            if (dim1 == 0) {
                return F.C0;
            }
            IAST a1 = (IAST)arg1;
            IAST a2 = (IAST)arg2;
            IAST plusAST = F.Plus();
            for (int i = 1; i < a1.size(); ++i) {
                plusAST.add(F.Sqr(F.Abs(F.Subtract((IExpr)a1.get(i), (IExpr)a2.get(i)))));
            }
            return F.Sqrt(plusAST);
        }
        return null;
    }

    @Override
    public IExpr numericEval(IAST functionList) {
        return this.evaluate(functionList);
    }

    @Override
    public void setUp(ISymbol symbol) {
    }
}

