/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.reflection.system;

import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.ComplexUtils;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.parser.client.SyntaxError;

public class Csch
extends AbstractTrigArg1
implements INumeric {
    @Override
    public IExpr evaluateArg1(IExpr arg1) {
        if (AbstractFunctionEvaluator.isNegativeExpression(arg1)) {
            return F.Times((IExpr)F.CN1, (IExpr)F.Csch(F.Times((IExpr)F.CN1, arg1)));
        }
        IExpr imPart = AbstractFunctionEvaluator.getPureImaginaryPart(arg1);
        if (imPart != null) {
            return F.Times((IExpr)F.CNI, (IExpr)F.Csc(imPart));
        }
        if (arg1.isZero()) {
            return F.CComplexInfinity;
        }
        return null;
    }

    @Override
    public IExpr numericEvalD1(Num arg1) {
        return F.num(1.0 / Math.sinh(arg1.getRealPart()));
    }

    @Override
    public IExpr numericEvalDC1(ComplexNum arg1) {
        return ComplexUtils.sinh(arg1).inverse();
    }

    @Override
    public double evalReal(double[] stack, int top, int size) {
        if (size != 1) {
            throw new UnsupportedOperationException();
        }
        return 1.0 / Math.sinh(stack[top]);
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(1152);
        super.setUp(symbol);
    }
}

