/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.patternmatching;

import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.patternmatching.DownRulesData;
import org.matheclipse.core.visit.HashValueVisitor;

public class HashedPatternRules {
    private int hash1;
    private int hash2;
    private DownRulesData fRulesData = null;
    private final IExpr fLHSPattern1;
    private final IExpr fLHSPattern2;
    private final IExpr fCondition;
    private final IExpr fRHS;

    public HashedPatternRules(IExpr lhsPattern1, IExpr lhsPattern2, IExpr rhsResult, boolean defaultHashCode) {
        this(lhsPattern1, lhsPattern2, rhsResult, null, defaultHashCode);
    }

    public HashedPatternRules(IExpr lhsPattern1, IExpr lhsPattern2, IExpr rhsResult, IExpr condition, boolean defaultHashCode) {
        this.fLHSPattern1 = lhsPattern1;
        this.fLHSPattern2 = lhsPattern2;
        this.fCondition = condition;
        this.fRHS = rhsResult;
        if (defaultHashCode) {
            this.hash1 = lhsPattern1.head().hashCode();
            this.hash2 = lhsPattern2.head().hashCode();
        } else {
            HashValueVisitor v = new HashValueVisitor();
            this.hash1 = lhsPattern1.accept(v);
            v.setUp();
            this.hash2 = lhsPattern2.accept(v);
            v.setUp();
        }
    }

    public IExpr getRHS() {
        return this.fRHS;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.hash1;
        result = 31 * result + this.hash2;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashedPatternRules) {
            HashedPatternRules other = (HashedPatternRules)obj;
            if (this.hash1 != other.hash1) {
                return false;
            }
            if (this.hash2 != other.hash2) {
                return false;
            }
            if (this.fLHSPattern1 == null ? other.fLHSPattern1 != null : !this.fLHSPattern1.equals(other.fLHSPattern1)) {
                return false;
            }
            if (this.fLHSPattern2 == null ? other.fLHSPattern2 != null : !this.fLHSPattern2.equals(other.fLHSPattern2)) {
                return false;
            }
            if (this.fCondition == null ? other.fCondition != null : !this.fCondition.equals(other.fCondition)) {
                return false;
            }
            return !(this.fRHS == null ? other.fRHS != null : !this.fRHS.equals(other.fRHS));
        }
        return false;
    }

    public IExpr getCondition() {
        return this.fCondition;
    }

    public int getHash1() {
        return this.hash1;
    }

    public int getHash2() {
        return this.hash2;
    }

    public boolean isPattern2() {
        return this.fLHSPattern2.isPattern();
    }

    public DownRulesData getRulesData() {
        if (this.fRulesData == null) {
            this.fRulesData = new DownRulesData();
            if (this.fCondition != null) {
                this.fRulesData.putDownRule(F.SetDelayed, false, F.List(this.fLHSPattern1, this.fLHSPattern2), F.Condition(this.fRHS, this.fCondition), 0);
            } else {
                this.fRulesData.putDownRule(F.SetDelayed, false, F.List(this.fLHSPattern1, this.fLHSPattern2), this.fRHS, 0);
            }
        }
        return this.fRulesData;
    }
}

