/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.generic.combinatoric;

import java.util.Iterator;

public class KPartitionsIterable
implements Iterator<int[]>,
Iterable<int[]> {
    private final int fLength;
    private final int fNumberOfParts;
    private final int[] fPartitionsIndex;
    private final int[] fCopiedResultIndex;
    private int[] fResultIndex;

    public KPartitionsIterable(int length, int parts) {
        this.fLength = length;
        this.fNumberOfParts = parts;
        this.fPartitionsIndex = new int[this.fNumberOfParts];
        this.fCopiedResultIndex = new int[this.fNumberOfParts];
        this.fPartitionsIndex[0] = -1;
        this.fResultIndex = this.nextBeforehand();
    }

    public final void reset() {
        this.fResultIndex = null;
        for (int i = 1; i < this.fNumberOfParts; ++i) {
            this.fPartitionsIndex[i] = 0;
        }
        this.fPartitionsIndex[0] = -1;
        this.fResultIndex = this.nextBeforehand();
    }

    private final int[] nextBeforehand() {
        if (this.fPartitionsIndex[0] < 0) {
            for (int i = 0; i < this.fNumberOfParts; ++i) {
                this.fPartitionsIndex[i] = i;
            }
            return this.fPartitionsIndex;
        }
        int i = 0;
        for (i = this.fNumberOfParts - 1; i >= 0 && this.fPartitionsIndex[i] >= this.fLength - this.fNumberOfParts + i; --i) {
        }
        if (i <= 0) {
            return null;
        }
        int n = i;
        this.fPartitionsIndex[n] = this.fPartitionsIndex[n] + 1;
        for (int m = i + 1; m < this.fNumberOfParts; ++m) {
            this.fPartitionsIndex[m] = this.fPartitionsIndex[m - 1] + 1;
        }
        return this.fPartitionsIndex;
    }

    @Override
    public int[] next() {
        System.arraycopy(this.fResultIndex, 0, this.fCopiedResultIndex, 0, this.fResultIndex.length);
        this.fResultIndex = this.nextBeforehand();
        return this.fCopiedResultIndex;
    }

    @Override
    public boolean hasNext() {
        return this.fResultIndex != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<int[]> iterator() {
        return this;
    }
}

