/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.form.tex.reflection;

import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.form.tex.AbstractConverter;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

public class MatrixForm
extends AbstractConverter {
    @Override
    public boolean convert(StringBuffer buf, IAST f, int precedence) {
        if (f.size() != 2) {
            return false;
        }
        IAST matrix = this.matrixQ((IExpr)f.get(1));
        if (matrix == null) {
            IAST vector = this.vectorQ((IExpr)f.get(1));
            if (vector == null) {
                return false;
            }
            buf.append("\\begin{pmatrix}");
            for (int i = 1; i < vector.size(); ++i) {
                IExpr element = (IExpr)vector.get(i);
                buf.append(' ');
                this.fFactory.convert(buf, element, 0);
                buf.append(' ');
                if (i >= vector.size() - 1) continue;
                buf.append('&');
            }
            buf.append("\\end{pmatrix}");
        } else {
            buf.append("\\begin{pmatrix}");
            for (int i = 1; i < matrix.size(); ++i) {
                IAST row = (IAST)matrix.get(i);
                for (int j = 1; j < row.size(); ++j) {
                    buf.append(' ');
                    this.fFactory.convert(buf, row.get(j), 0);
                    buf.append(' ');
                    if (j >= row.size() - 1) continue;
                    buf.append('&');
                }
                buf.append("\\\\\n");
            }
            buf.append("\\end{pmatrix}");
        }
        return true;
    }

    public IAST matrixQ(IExpr expr) {
        if (!(expr instanceof IAST)) {
            return null;
        }
        IAST list = (IAST)expr;
        if (!list.topHead().toString().equals(AST2Expr.LIST_STRING)) {
            return null;
        }
        int size = list.size();
        int subSize = -1;
        for (int i = 1; i < size; ++i) {
            IExpr temp = (IExpr)list.get(i);
            if (!(temp instanceof IAST)) {
                return null;
            }
            IAST subList = (IAST)temp;
            if (!subList.topHead().toString().equals(AST2Expr.LIST_STRING)) {
                return null;
            }
            if (subSize < 0) {
                subSize = subList.size();
                continue;
            }
            if (subSize == subList.size()) continue;
            return null;
        }
        return list;
    }

    public IAST vectorQ(IExpr expr) {
        if (!(expr instanceof IAST)) {
            return null;
        }
        IAST list = (IAST)expr;
        if (!list.topHead().toString().equals(AST2Expr.LIST_STRING)) {
            return null;
        }
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            IExpr temp = (IExpr)list.get(i);
            if (!(temp instanceof IAST) || !((IAST)temp).topHead().toString().equals(AST2Expr.LIST_STRING)) continue;
            return null;
        }
        return list;
    }
}

