/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.expression;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;

public class Primality {
    private static final SecureRandom random = new SecureRandom();
    private static final BigInteger TWO = new BigInteger("2");
    private static final int[] primes = new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131, 137, 139, 149, 151, 157, 163, 167, 173, 179, 181, 191, 193, 197, 199, 211, 223, 227, 229, 233, 239, 241, 251, 257, 263, 269, 271, 277, 281, 283, 293, 307, 311, 313, 317, 331, 337, 347, 349, 353, 359, 367, 373, 379, 383, 389, 397, 401, 409, 419, 421, 431, 433, 439, 443, 449, 457, 461, 463, 467, 479, 487, 491, 499, 503, 509, 521, 523, 541, 547, 557, 563, 569, 571, 577, 587, 593, 599, 601, 607, 613, 617, 619, 631, 641, 643, 647, 653, 659, 661, 673, 677, 683, 691, 701, 709, 719, 727, 733, 739, 743, 751, 757, 761, 769, 773, 787, 797, 809, 811, 821, 823, 827, 829, 839, 853, 857, 859, 863, 877, 881, 883, 887, 907, 911, 919, 929, 937, 941, 947, 953, 967, 971, 977, 983, 991, 997, 1009, 1013, 1019, 1021};
    private static final BigInteger[] BIprimes = new BigInteger[primes.length];
    private static final int[] BITS = new int[]{0, 0, 1854, 1233, 927, 747, 627, 543, 480, 431, 393, 361, 335, 314, 295, 279, 265, 253, 242, 232, 223, 216, 181, 169, 158, 150, 145, 140, 136, 132, 127, 123, 119, 114, 110, 105, 101, 96, 92, 87, 83, 78, 73, 69, 64, 59, 54, 49, 44, 38, 32, 26, 1};
    private static final int[][] offsetPrimes = new int[][]{null, null, {0, 2}, {2, 2}, {4, 2}, {6, 5}, {11, 7}, {18, 13}, {31, 23}, {54, 43}, {97, 75}};

    private Primality() {
    }

    public static BigInteger countPrimes1021(BigInteger val, Map<Integer, Integer> map) {
        BigInteger result = val;
        block0: for (int i = 0; i < primes.length && result.compareTo(BIprimes[i]) >= 0; ++i) {
            BigInteger[] divRem = result.divideAndRemainder(BIprimes[i]);
            while (divRem[1].equals(BigInteger.ZERO)) {
                Integer count = map.get(primes[i]);
                if (count == null) {
                    map.put(primes[i], 1);
                } else {
                    map.put(primes[i], count + 1);
                }
                result = divRem[0];
                if (result.compareTo(BIprimes[i]) < 0) continue block0;
                divRem = result.divideAndRemainder(BIprimes[i]);
            }
        }
        return result;
    }

    public static void pollardRhoFactors(BigInteger val, Map<BigInteger, Integer> map) {
        Integer count;
        BigInteger temp = val;
        int iterationCounter = 0;
        while (!temp.isProbablePrime(32)) {
            BigInteger factor = Primality.rho(temp);
            if (factor.equals(temp)) {
                if (iterationCounter++ > 4) {
                    break;
                }
            } else {
                iterationCounter = 1;
            }
            if ((count = map.get(factor)) == null) {
                map.put(factor, 1);
            } else {
                map.put(factor, count + 1);
            }
            temp = temp.divide(factor);
        }
        if ((count = map.get(temp)) == null) {
            map.put(temp, 1);
        } else {
            map.put(temp, count + 1);
        }
    }

    private static BigInteger rho(BigInteger val) {
        BigInteger divisor;
        BigInteger x;
        BigInteger c = new BigInteger(val.bitLength(), random);
        BigInteger xx = x = new BigInteger(val.bitLength(), random);
        do {
            x = x.multiply(x).mod(val).add(c).mod(val);
            xx = xx.multiply(xx).mod(val).add(c).mod(val);
        } while ((divisor = x.subtract(xx = xx.multiply(xx).mod(val).add(c).mod(val)).gcd(val)).equals(BigInteger.ONE));
        return divisor;
    }

    static {
        for (int i = 0; i < primes.length; ++i) {
            Primality.BIprimes[i] = BigInteger.valueOf(primes[i]);
        }
    }
}

