/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.parser.client.math.MathException;

public class WrongNumberOfArguments
extends MathException {
    private static final long serialVersionUID = 754625729654866796L;
    int fAllowed;
    int fCurrent;
    IAST fExpr;
    int fTextNumber;

    public WrongNumberOfArguments(IAST expr, int allowed, int current) {
        this.fAllowed = allowed;
        this.fCurrent = current;
        this.fExpr = expr;
        this.fTextNumber = 0;
    }

    public WrongNumberOfArguments(int textNumber, IAST expr, int current) {
        this.fAllowed = 0;
        this.fCurrent = current;
        this.fExpr = expr;
        this.fTextNumber = textNumber;
    }

    @Override
    public String getMessage() {
        switch (this.fTextNumber) {
            case 0: {
                return "Expected number of arguments: " + this.fAllowed + " but got " + this.fCurrent + " arguments:\n" + this.fExpr.toString();
            }
            case 1: {
                return "Expected even number of arguments but got " + this.fCurrent + " arguments:\n" + this.fExpr.toString();
            }
            case 2: {
                return "Expected odd number of arguments but got " + this.fCurrent + " arguments:\n" + this.fExpr.toString();
            }
        }
        return "Wrong text number: " + this.fAllowed + " but got " + this.fCurrent + " arguments:\n" + this.fExpr.toString();
    }
}

