/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval.exception;

import org.matheclipse.core.eval.exception.WrongArgumentType;
import org.matheclipse.core.eval.exception.WrongNumberOfArguments;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public final class Validate {
    public static int checkIntType(IAST ast, int pos) {
        return Validate.checkIntType(ast, pos, 0);
    }

    public static int checkPowerExponent(IAST ast) {
        int exponent = 0;
        try {
            if (ast.get(2) instanceof IInteger) {
                exponent = ((IInteger)ast.get(2)).toInt();
                return exponent;
            }
            if (ast.get(2) instanceof INum) {
                exponent = ((INum)ast.get(2)).toInt();
                return exponent;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(2), 2, "Trying to convert the argument into an integer exponent: " + ast.get(2));
    }

    public static int checkIntType(IAST ast, int pos, int startValue) {
        if (((IExpr)ast.get(pos)).isSignedNumber()) {
            try {
                int result = ((ISignedNumber)ast.get(pos)).toInt();
                if (startValue > result) {
                    throw new WrongArgumentType(ast, (IExpr)ast.get(pos), pos, "Trying to convert the argument into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
                }
                return result;
            }
            catch (ArithmeticException ae) {
                throw new WrongArgumentType(ast, (IExpr)ast.get(pos), pos, "Trying to convert the argument into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
            }
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(pos), pos, "Trying to convert the argument into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
    }

    public static int checkIntType(IExpr expr) {
        return Validate.checkIntType(expr, 0);
    }

    public static int checkIntType(IExpr expr, int startValue) {
        if (expr.isSignedNumber()) {
            try {
                int result = ((ISignedNumber)expr).toInt();
                if (startValue > result) {
                    throw new WrongArgumentType(expr, "Trying to convert the expression into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
                }
                return result;
            }
            catch (ArithmeticException ae) {
                throw new WrongArgumentType(expr, "Trying to convert the expression into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
            }
        }
        throw new WrongArgumentType(expr, "Trying to convert the expression into the integer range: " + startValue + " - " + Integer.MAX_VALUE);
    }

    public static IInteger checkIntegerType(IAST ast, int position) {
        if (((IExpr)ast.get(position)).isInteger()) {
            return (IInteger)ast.get(position);
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(position), position, "Integer expected!");
    }

    public static IAST checkRange(IAST ast, int from) {
        return Validate.checkRange(ast, from, Integer.MAX_VALUE);
    }

    public static IAST checkRange(IAST ast, int from, int to) {
        if (ast.size() < from) {
            throw new WrongNumberOfArguments(ast, from - 1, ast.size() - 1);
        }
        if (ast.size() > to) {
            throw new WrongNumberOfArguments(ast, to - 1, ast.size() - 1);
        }
        return ast;
    }

    public static IAST checkSize(IAST ast, int size) {
        if (ast.size() != size) {
            throw new WrongNumberOfArguments(ast, size - 1, ast.size() - 1);
        }
        return ast;
    }

    public static IAST checkEven(IAST ast) {
        if ((ast.size() - 1 & 1) == 1) {
            throw new WrongNumberOfArguments(1, ast, ast.size() - 1);
        }
        return ast;
    }

    public static IAST checkOdd(IAST ast) {
        if ((ast.size() - 1 & 1) == 0) {
            throw new WrongNumberOfArguments(2, ast, ast.size() - 1);
        }
        return ast;
    }

    public static IStringX checkStringType(IAST ast, int position) {
        if (ast.get(position) instanceof IStringX) {
            return (IStringX)ast.get(position);
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(position), position, "String expected!");
    }

    public static IAST checkSymbolOrSymbolList(IAST ast, int position) {
        IAST vars = null;
        if (((IExpr)ast.get(position)).isList()) {
            vars = (IAST)ast.get(position);
            for (int i = 1; i < vars.size(); ++i) {
                Validate.checkSymbolType(vars, i);
            }
            return vars;
        }
        return F.List((IExpr)Validate.checkSymbolType(ast, position));
    }

    public static IAST checkSymbolList(IAST ast, int position) {
        IAST vars = null;
        if (((IExpr)ast.get(position)).isList()) {
            vars = (IAST)ast.get(position);
            for (int i = 1; i < vars.size(); ++i) {
                Validate.checkSymbolType(vars, i);
            }
            return vars;
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(position), position, "List of symbols expected!");
    }

    public static ISymbol checkAssignedVariable(IExpr expr) {
        if (expr.isSymbol()) {
            return (ISymbol)expr;
        }
        throw new WrongArgumentType(expr, "Failed to convert expression: " + expr.toString() + " into a variable!");
    }

    public static ISymbol checkSymbolType(IAST ast, int position) {
        if (((IExpr)ast.get(position)).isSymbol()) {
            return (ISymbol)ast.get(position);
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(position), position, "Symbol expected!");
    }

    public static IAST checkASTUpRuleType(IExpr expr) {
        if (expr.isAST()) {
            IAST ast = (IAST)expr;
            return ast;
        }
        throw new WrongArgumentType(expr, "Function(AST)  in left-hand-side of UpSet[] or UpSetDelayed[] expected!");
    }

    public static IAST checkASTType(IAST ast, int position) {
        if (((IExpr)ast.get(position)).isAST()) {
            return (IAST)ast.get(position);
        }
        throw new WrongArgumentType(ast, (IExpr)ast.get(position), position, "Function(AST) expected!");
    }

    public static IAST checkASTType(IExpr expr) {
        if (expr.isAST()) {
            return (IAST)expr;
        }
        throw new WrongArgumentType(expr, "Function(AST) expected!");
    }

    private Validate() {
    }
}

