/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.eval;

import java.io.Writer;
import org.matheclipse.core.convert.AST2Expr;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.form.mathml.MathMLFormFactory;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.parser.client.ast.ASTNode;

public class MathMLUtilities {
    protected EvalEngine fEvalEngine;
    protected MathMLFormFactory fMathMLFactory;
    boolean fMSIE;
    boolean fMathMLHeader;

    public MathMLUtilities(EvalEngine evalEngine, boolean mathMTagPrefix, boolean mathMLHeader) {
        this.fEvalEngine = evalEngine;
        this.startRequest();
        this.fMathMLFactory = mathMTagPrefix ? new MathMLFormFactory("m:") : new MathMLFormFactory();
        this.fMSIE = mathMTagPrefix;
        this.fMathMLHeader = mathMLHeader;
    }

    public synchronized void toMathML(String inputExpression, Writer out) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ASTNode node = this.fEvalEngine.parseNode(inputExpression);
                parsedExpression = AST2Expr.CONST.convert(node);
            }
            catch (Throwable e) {
                return;
            }
        }
        this.toMathML(parsedExpression, out);
    }

    public synchronized void toMathML(IExpr objectExpression, Writer out) {
        StringBuffer buf = new StringBuffer();
        if (objectExpression != null) {
            this.fMathMLFactory.convert(buf, objectExpression, 0);
            try {
                if (this.fMSIE) {
                    out.write("<m:math>");
                    out.write(buf.toString());
                    out.write("</m:math>");
                } else {
                    if (this.fMathMLHeader) {
                        out.write("<?xml version=\"1.0\"?>\n<!DOCTYPE math PUBLIC \"-//W3C//DTD MathML 2.0//EN\" \"http://www.w3.org/TR/MathML2/dtd/mathml2.dtd\">\n<math mode=\"display\">\n");
                    } else {
                        out.write("<math>");
                    }
                    out.write(buf.toString());
                    out.write("</math>");
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
    }

    public synchronized void toJava(String inputExpression, Writer out, boolean strictJava) {
        IExpr parsedExpression = null;
        if (inputExpression != null) {
            try {
                ASTNode node = this.fEvalEngine.parseNode(inputExpression);
                parsedExpression = AST2Expr.CONST.convert(node);
                out.write(parsedExpression.internalFormString(strictJava, 0));
            }
            finally {
                return;
            }
        }
    }

    public void startRequest() {
        EvalEngine.set(this.fEvalEngine);
    }

    public void stopRequest() {
        this.fEvalEngine.stopRequest();
    }

    static {
        F.initSymbols(null, null, true);
    }
}

