/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.util.ISequence;
import org.matheclipse.core.eval.util.Sequence;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class Drop
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST ast) {
        Validate.checkRange(ast, 3);
        IExpr arg1 = F.eval(ast.arg1());
        try {
            if (arg1.isAST()) {
                Sequence sequ = Sequence.createSequence(ast.arg2());
                IAST list = (IAST)arg1;
                if (sequ != null) {
                    IAST resultList = list.clone();
                    Drop.drop(resultList, sequ);
                    return resultList;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) {
        symbol.setAttributes(16384);
    }

    public static IAST drop(IAST resultList, ISequence sequenceSpecification) {
        int j;
        sequenceSpecification.setListSize(resultList.size());
        for (int i = j = sequenceSpecification.getStart(); i < sequenceSpecification.getEnd(); i += sequenceSpecification.getStep()) {
            resultList.remove(j);
            j += sequenceSpecification.getStep() - 1;
        }
        return resultList;
    }
}

