/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin.function;

import com.google.common.base.Function;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.util.Options;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.generic.Functors;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.visit.VisitorLevelSpecification;
import org.matheclipse.parser.client.SyntaxError;

public class Apply
extends AbstractCoreFunctionEvaluator {
    @Override
    public IExpr evaluate(IAST inp) {
        Validate.checkRange(inp, 3, 5);
        IAST ast = inp.clone();
        for (int i = 1; i < ast.size(); ++i) {
            ast.set(i, F.eval((IExpr)ast.get(i)));
        }
        int lastIndex = ast.size() - 1;
        boolean heads = false;
        Options options = new Options(ast.topHead(), ast, lastIndex);
        IExpr option = options.getOption("Heads");
        if (option != null) {
            --lastIndex;
            if (option.isTrue()) {
                heads = true;
            }
        } else {
            Validate.checkRange(ast, 3, 4);
        }
        VisitorLevelSpecification level = null;
        Function<IExpr, IExpr> af = Functors.apply(ast.arg1());
        level = lastIndex == 3 ? new VisitorLevelSpecification(af, (IExpr)ast.get(lastIndex), heads) : new VisitorLevelSpecification(af, 0);
        try {
            if (!ast.arg2().isAtom()) {
                IExpr result = ast.arg2().accept(level);
                return result == null ? ast.arg2() : result;
            }
            if (ast.size() == 3) {
                if (((IExpr)ast.get(1)).isFunction()) {
                    IAST fun = F.ast((IExpr)ast.get(1));
                    fun.add(ast.arg2());
                    return fun;
                }
                return ast.arg2();
            }
        }
        catch (ArithmeticException e) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void setUp(ISymbol symbol) throws SyntaxError {
        symbol.setAttributes(96);
    }
}

