/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.boole;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import org.matheclipse.core.eval.exception.BooleanFunctionConversionException;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;

class QuineMcCluskyTerm {
    public static final byte NIL = 2;
    private byte[] varVals;

    public QuineMcCluskyTerm(byte[] varVals) {
        this.varVals = varVals;
    }

    public int getNumVars() {
        return this.varVals.length;
    }

    public String toString() {
        String result = "{";
        for (int i = 0; i < this.varVals.length; ++i) {
            result = this.varVals[i] == 2 ? result + "X" : result + this.varVals[i];
            result = result + " ";
        }
        result = result + "}";
        return result;
    }

    public IExpr toExpr(IAST variables) throws BooleanFunctionConversionException {
        if (this.varVals.length == 1 && this.varVals[0] != 2) {
            if (this.varVals[0] == 0) {
                return F.Not((IExpr)variables.get(1));
            }
            if (this.varVals[0] == 1) {
                return (IExpr)variables.get(1);
            }
            throw new BooleanFunctionConversionException();
        }
        IAST result = F.ast(F.And);
        for (int i = 0; i < this.varVals.length; ++i) {
            if (this.varVals[i] == 2) continue;
            if (this.varVals[i] == 0) {
                result.add(F.Not((IExpr)variables.get(i + 1)));
                continue;
            }
            if (this.varVals[i] == 1) {
                result.add(variables.get(i + 1));
                continue;
            }
            throw new BooleanFunctionConversionException();
        }
        if (result.size() == 1) {
            return F.False;
        }
        if (result.size() == 2) {
            return (IExpr)result.get(1);
        }
        return result;
    }

    public QuineMcCluskyTerm combine(QuineMcCluskyTerm term) {
        int diffVarNum = -1;
        for (int i = 0; i < this.varVals.length; ++i) {
            if (this.varVals[i] == term.varVals[i]) continue;
            if (diffVarNum == -1) {
                diffVarNum = i;
                continue;
            }
            return null;
        }
        if (diffVarNum == -1) {
            return null;
        }
        byte[] resultVars = (byte[])this.varVals.clone();
        resultVars[diffVarNum] = 2;
        return new QuineMcCluskyTerm(resultVars);
    }

    public int countValues(byte value) {
        int result = 0;
        for (int i = 0; i < this.varVals.length; ++i) {
            if (this.varVals[i] != value) continue;
            ++result;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !this.getClass().equals(o.getClass())) {
            return false;
        }
        QuineMcCluskyTerm rhs = (QuineMcCluskyTerm)o;
        return Arrays.equals(this.varVals, rhs.varVals);
    }

    public int hashCode() {
        return Arrays.hashCode(this.varVals);
    }

    boolean implies(QuineMcCluskyTerm term) {
        for (int i = 0; i < this.varVals.length; ++i) {
            if (this.varVals[i] == 2 || this.varVals[i] == term.varVals[i]) continue;
            return false;
        }
        return true;
    }

    public static QuineMcCluskyTerm read(Reader reader) throws IOException {
        int c = 0;
        ArrayList<Byte> t = new ArrayList<Byte>();
        while (c != 10 && c != -1) {
            c = reader.read();
            if (c == 48) {
                t.add((byte)0);
                continue;
            }
            if (c != 49) continue;
            t.add((byte)1);
        }
        if (t.size() > 0) {
            byte[] resultBytes = new byte[t.size()];
            for (int i = 0; i < t.size(); ++i) {
                resultBytes[i] = (Byte)t.get(i);
            }
            return new QuineMcCluskyTerm(resultBytes);
        }
        return null;
    }

    public static ArrayList<QuineMcCluskyTerm> read(String str) {
        ArrayList<QuineMcCluskyTerm> terms = new ArrayList<QuineMcCluskyTerm>();
        int j = 0;
        ArrayList<Byte> t = null;
        do {
            t = new ArrayList<Byte>();
            int c = 0;
            while (c != 10 && j < str.length()) {
                if ((c = (int)str.charAt(j++)) == 48) {
                    t.add((byte)0);
                    continue;
                }
                if (c != 49) continue;
                t.add((byte)1);
            }
            if (t.size() <= 0) continue;
            QuineMcCluskyTerm.addBytes(terms, t);
        } while (t.size() > 0);
        return terms;
    }

    public static ArrayList<QuineMcCluskyTerm> convertToTerms(IAST orAST, IAST vars) throws BooleanFunctionConversionException {
        ArrayList<QuineMcCluskyTerm> terms = new ArrayList<QuineMcCluskyTerm>();
        for (int i = 1; i < orAST.size(); ++i) {
            IExpr temp = (IExpr)orAST.get(i);
            ArrayList<Byte> t = new ArrayList<Byte>();
            for (int j = 1; j < vars.size(); ++j) {
                t.add((byte)2);
            }
            if (temp.isAST(F.And)) {
                IAST andAST = (IAST)temp;
                block2: for (int j = 1; j < andAST.size(); ++j) {
                    IExpr a = (IExpr)andAST.get(j);
                    if (a.isAST(F.Not, 2)) {
                        IExpr arg1 = a.getAt(1);
                        if (!arg1.isSymbol()) {
                            throw new BooleanFunctionConversionException();
                        }
                        for (int j2 = 1; j2 < vars.size(); ++j2) {
                            if (!arg1.equals(vars.get(j2))) continue;
                            t.set(j2 - 1, (byte)0);
                            continue block2;
                        }
                        continue;
                    }
                    if (a.isSymbol()) {
                        for (int j2 = 1; j2 < vars.size(); ++j2) {
                            if (!a.equals(vars.get(j2))) continue;
                            t.set(j2 - 1, (byte)1);
                            continue block2;
                        }
                        continue;
                    }
                    throw new BooleanFunctionConversionException();
                }
            } else {
                throw new BooleanFunctionConversionException();
            }
            if (t.size() <= 0) continue;
            QuineMcCluskyTerm.addBytes(terms, t);
        }
        return terms;
    }

    private static void addBytes(ArrayList<QuineMcCluskyTerm> terms, ArrayList<Byte> t) {
        byte[] resultBytes = new byte[t.size()];
        for (int j3 = 0; j3 < t.size(); ++j3) {
            if (t.get(j3).equals((byte)2)) {
                t.set(j3, (byte)0);
                QuineMcCluskyTerm.addBytes(terms, t);
                t.set(j3, (byte)1);
                QuineMcCluskyTerm.addBytes(terms, t);
                return;
            }
            resultBytes[j3] = t.get(j3);
        }
        QuineMcCluskyTerm term = new QuineMcCluskyTerm(resultBytes);
        terms.add(term);
    }
}

