/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.FoldManager;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RegExReplaceInfo;
import org.fife.ui.rtextarea.SearchContext;

public class SearchEngine {
    private SearchEngine() {
    }

    public static boolean find(JTextArea textArea, SearchContext context) {
        String text = context.getSearchFor();
        if (text == null || text.length() == 0) {
            return false;
        }
        Caret c = textArea.getCaret();
        boolean forward = context.getSearchForward();
        int start = forward ? Math.max(c.getDot(), c.getMark()) : Math.min(c.getDot(), c.getMark());
        String findIn = SearchEngine.getFindInText(textArea, start, forward);
        if (findIn == null || findIn.length() == 0) {
            return false;
        }
        if (!context.isRegularExpression()) {
            int pos = SearchEngine.getNextMatchPos(text, findIn, forward, context.getMatchCase(), context.getWholeWord());
            findIn = null;
            if (pos != -1) {
                c.setSelectionVisible(true);
                pos = forward ? start + pos : pos;
                SearchEngine.selectAndPossiblyCenter(textArea, pos, pos + text.length());
                return true;
            }
        } else {
            Point regExPos = SearchEngine.getNextMatchPosRegEx(text, findIn, forward, context.getMatchCase(), context.getWholeWord());
            findIn = null;
            if (regExPos != null) {
                c.setSelectionVisible(true);
                if (forward) {
                    regExPos.translate(start, start);
                }
                SearchEngine.selectAndPossiblyCenter(textArea, regExPos.x, regExPos.y);
                return true;
            }
        }
        return false;
    }

    private static String getFindInText(JTextArea textArea, int start, boolean forward) {
        String findIn = null;
        if (forward) {
            try {
                findIn = textArea.getText(start, textArea.getDocument().getLength() - start);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        } else {
            try {
                findIn = textArea.getText(0, start);
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
        return findIn;
    }

    private static List getMatches(Matcher m, String replaceStr) {
        ArrayList<Object> matches = new ArrayList<Object>();
        while (m.find()) {
            Point loc = new Point(m.start(), m.end());
            if (replaceStr == null) {
                matches.add(loc);
                continue;
            }
            matches.add(new RegExReplaceInfo(m.group(0), loc.x, loc.y, SearchEngine.getReplacementText(m, replaceStr)));
        }
        return matches;
    }

    public static final int getNextMatchPos(String searchFor, String searchIn, boolean forward, boolean matchCase, boolean wholeWord) {
        if (!matchCase) {
            return SearchEngine.getNextMatchPosImpl(searchFor.toLowerCase(), searchIn.toLowerCase(), forward, matchCase, wholeWord);
        }
        return SearchEngine.getNextMatchPosImpl(searchFor, searchIn, forward, matchCase, wholeWord);
    }

    private static final int getNextMatchPosImpl(String searchFor, String searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        if (wholeWord) {
            int len = searchFor.length();
            int temp = goForward ? 0 : searchIn.length();
            int tempChange = goForward ? 1 : -1;
            while ((temp = goForward ? searchIn.indexOf(searchFor, temp) : searchIn.lastIndexOf(searchFor, temp)) != -1) {
                if (SearchEngine.isWholeWord(searchIn, temp, len)) {
                    return temp;
                }
                temp += tempChange;
            }
            return temp;
        }
        return goForward ? searchIn.indexOf(searchFor) : searchIn.lastIndexOf(searchFor);
    }

    private static Point getNextMatchPosRegEx(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord) {
        return (Point)SearchEngine.getNextMatchPosRegExImpl(regEx, searchIn, goForward, matchCase, wholeWord, null);
    }

    private static Object getNextMatchPosRegExImpl(String regEx, CharSequence searchIn, boolean goForward, boolean matchCase, boolean wholeWord, String replaceStr) {
        if (wholeWord) {
            regEx = "\\b" + regEx + "\\b";
        }
        int flags = 8;
        Pattern pattern = Pattern.compile(regEx, flags |= matchCase ? 0 : 66);
        Matcher m = pattern.matcher(searchIn);
        if (goForward) {
            if (m.find()) {
                if (replaceStr == null) {
                    return new Point(m.start(), m.end());
                }
                return new RegExReplaceInfo(m.group(0), m.start(), m.end(), SearchEngine.getReplacementText(m, replaceStr));
            }
        } else {
            List matches = SearchEngine.getMatches(m, replaceStr);
            if (!matches.isEmpty()) {
                return matches.get(matches.size() - 1);
            }
        }
        return null;
    }

    private static RegExReplaceInfo getRegExReplaceInfo(String searchIn, SearchContext context) {
        String replacement = context.getReplaceWith();
        if (replacement == null) {
            replacement = "";
        }
        String regex = context.getSearchFor();
        boolean goForward = context.getSearchForward();
        boolean matchCase = context.getMatchCase();
        boolean wholeWord = context.getWholeWord();
        return (RegExReplaceInfo)SearchEngine.getNextMatchPosRegExImpl(regex, searchIn, goForward, matchCase, wholeWord, replacement);
    }

    public static String getReplacementText(Matcher m, CharSequence template) {
        int cursor = 0;
        StringBuffer result = new StringBuffer();
        while (cursor < template.length()) {
            char nextChar = template.charAt(cursor);
            if (nextChar == '\\') {
                nextChar = template.charAt(++cursor);
                switch (nextChar) {
                    case 'n': {
                        nextChar = '\n';
                        break;
                    }
                    case 't': {
                        nextChar = '\t';
                    }
                }
                result.append(nextChar);
                ++cursor;
                continue;
            }
            if (nextChar == '$') {
                int nextDigit;
                int refNum;
                if ((refNum = template.charAt(++cursor) - 48) < 0 || refNum > 9) {
                    throw new IndexOutOfBoundsException("No group " + template.charAt(cursor));
                }
                ++cursor;
                boolean done = false;
                while (!done && cursor < template.length() && (nextDigit = template.charAt(cursor) - 48) >= 0 && nextDigit <= 9) {
                    int newRefNum = refNum * 10 + nextDigit;
                    if (m.groupCount() < newRefNum) {
                        done = true;
                        continue;
                    }
                    refNum = newRefNum;
                    ++cursor;
                }
                if (m.group(refNum) == null) continue;
                result.append(m.group(refNum));
                continue;
            }
            result.append(nextChar);
            ++cursor;
        }
        return result.toString();
    }

    private static final boolean isWholeWord(CharSequence searchIn, int offset, int len) {
        boolean wsAfter;
        boolean wsBefore;
        try {
            wsBefore = !Character.isLetterOrDigit(searchIn.charAt(offset - 1));
        }
        catch (IndexOutOfBoundsException e) {
            wsBefore = true;
        }
        try {
            wsAfter = !Character.isLetterOrDigit(searchIn.charAt(offset + len));
        }
        catch (IndexOutOfBoundsException e) {
            wsAfter = true;
        }
        return wsBefore && wsAfter;
    }

    private static int makeMarkAndDotEqual(JTextArea textArea, boolean forward) {
        Caret c = textArea.getCaret();
        int val = forward ? Math.min(c.getDot(), c.getMark()) : Math.max(c.getDot(), c.getMark());
        c.setDot(val);
        return val;
    }

    private static boolean regexReplace(JTextArea textArea, SearchContext context) throws PatternSyntaxException {
        Caret c = textArea.getCaret();
        boolean forward = context.getSearchForward();
        int start = SearchEngine.makeMarkAndDotEqual(textArea, forward);
        String findIn = SearchEngine.getFindInText(textArea, start, forward);
        if (findIn == null) {
            return false;
        }
        RegExReplaceInfo info = SearchEngine.getRegExReplaceInfo(findIn, context);
        findIn = null;
        if (info != null) {
            c.setSelectionVisible(true);
            int matchStart = info.getStartIndex();
            int matchEnd = info.getEndIndex();
            if (forward) {
                matchStart += start;
                matchEnd += start;
            }
            SearchEngine.selectAndPossiblyCenter(textArea, matchStart, matchEnd);
            textArea.replaceSelection(info.getReplacement());
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean replace(RTextArea textArea, SearchContext context) throws PatternSyntaxException {
        String toFind = context.getSearchFor();
        if (toFind == null || toFind.length() == 0) {
            return false;
        }
        textArea.beginAtomicEdit();
        try {
            if (context.isRegularExpression()) {
                boolean bl = SearchEngine.regexReplace(textArea, context);
                return bl;
            }
            SearchEngine.makeMarkAndDotEqual(textArea, context.getSearchForward());
            if (SearchEngine.find(textArea, context)) {
                textArea.replaceSelection(context.getReplaceWith());
                boolean bl = true;
                return bl;
            }
        }
        finally {
            textArea.endAtomicEdit();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int replaceAll(RTextArea textArea, SearchContext context) throws PatternSyntaxException {
        String toFind = context.getSearchFor();
        if (toFind == null || toFind.length() == 0) {
            return 0;
        }
        int count = 0;
        textArea.beginAtomicEdit();
        try {
            int oldOffs = textArea.getCaretPosition();
            textArea.setCaretPosition(0);
            while (SearchEngine.replace(textArea, context)) {
                ++count;
            }
            if (count == 0) {
                textArea.setCaretPosition(oldOffs);
            }
        }
        finally {
            textArea.endAtomicEdit();
        }
        return count;
    }

    private static void selectAndPossiblyCenter(JTextArea textArea, int start, int end) {
        RSyntaxTextArea rsta;
        FoldManager fm;
        boolean foldsExpanded = false;
        if (textArea instanceof RSyntaxTextArea && (fm = (rsta = (RSyntaxTextArea)textArea).getFoldManager()).isCodeFoldingSupportedAndEnabled()) {
            foldsExpanded = fm.ensureOffsetNotInClosedFold(start);
            foldsExpanded |= fm.ensureOffsetNotInClosedFold(end);
        }
        textArea.setSelectionStart(start);
        textArea.setSelectionEnd(end);
        Rectangle r = null;
        try {
            r = textArea.modelToView(start);
            if (r == null) {
                return;
            }
            if (end != start) {
                r = r.union(textArea.modelToView(end));
            }
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
            textArea.setSelectionStart(start);
            textArea.setSelectionEnd(end);
            return;
        }
        Rectangle visible = textArea.getVisibleRect();
        if (!foldsExpanded && visible.contains(r)) {
            textArea.setSelectionStart(start);
            textArea.setSelectionEnd(end);
            return;
        }
        visible.x = r.x - (visible.width - r.width) / 2;
        visible.y = r.y - (visible.height - r.height) / 2;
        Rectangle bounds = textArea.getBounds();
        Insets i = textArea.getInsets();
        bounds.x = i.left;
        bounds.y = i.top;
        bounds.width -= i.left + i.right;
        bounds.height -= i.top + i.bottom;
        if (visible.x < bounds.x) {
            visible.x = bounds.x;
        }
        if (visible.x + visible.width > bounds.x + bounds.width) {
            visible.x = bounds.x + bounds.width - visible.width;
        }
        if (visible.y < bounds.y) {
            visible.y = bounds.y;
        }
        if (visible.y + visible.height > bounds.y + bounds.height) {
            visible.y = bounds.y + bounds.height - visible.height;
        }
        textArea.scrollRectToVisible(visible);
    }
}

