/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.statistics.distribution.DiscreteDistribution;
import net.doodleproject.numerics4j.statistics.distribution.SaddlePointExpansion;

public class PoissonDistribution
extends DiscreteDistribution {
    private double mean;

    public PoissonDistribution() {
        this(1.0);
    }

    public PoissonDistribution(double m) {
        this.setMean(m);
    }

    @Override
    public double cumulativeProbability(int x) throws NumericException {
        double ret = x < 0 ? 0.0 : this.simpleCumulativeProbability(0, x);
        return ret;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws NumericException {
        int ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Integer.MIN_VALUE : (p == 0.0 ? -1 : (p == 1.0 ? Integer.MAX_VALUE : this.findInverseCumulativeProbability(p, 0, (int)(this.mean + 0.5), Integer.MAX_VALUE)));
        return ret;
    }

    @Override
    public double probability(int x) {
        double ret = x < 0 ? 0.0 : (x == 0 ? Math.exp(-this.mean) : Math.exp(-SaddlePointExpansion.getStirlingError(x) - SaddlePointExpansion.getDeviancePart(x, this.mean)) / Math.sqrt(Math.PI * 2 * (double)x));
        return ret;
    }

    public double getMean() {
        return this.mean;
    }

    public void setMean(double m) {
        if (Double.isNaN(m) || m <= 0.0) {
            throw new IllegalArgumentException("mean must be positive.");
        }
        this.mean = m;
    }
}

