/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.statistics.distribution.DiscreteDistribution;
import net.doodleproject.numerics4j.statistics.distribution.SaddlePointExpansion;

public class HypergeometricDistribution
extends DiscreteDistribution {
    private int numberOfFailures;
    private int numberOfSuccesses;
    private int sampleSize;
    private int domainLowerBound;
    private int domainUpperBound;

    public HypergeometricDistribution() {
        this(1, 1, 1);
    }

    public HypergeometricDistribution(int successes, int failures, int sample) {
        this.setNumberOfFailures(failures);
        this.setNumberOfSuccesses(successes);
        this.setSampleSize(sample);
    }

    @Override
    public double cumulativeProbability(int x) throws NumericException {
        double ret = x < this.domainLowerBound ? 0.0 : (x >= this.domainUpperBound ? 1.0 : this.simpleCumulativeProbability(this.domainLowerBound, x));
        return ret;
    }

    public int getNumberOfFailures() {
        return this.numberOfFailures;
    }

    public int getNumberOfSuccesses() {
        return this.numberOfSuccesses;
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    @Override
    public int inverseCumulativeProbability(double p) throws NumericException {
        int ret;
        if (p < 0.0 || p > 1.0 || Double.isNaN(p)) {
            ret = Integer.MIN_VALUE;
        } else if (p == 0.0) {
            ret = this.domainLowerBound - 1;
        } else if (p == 1.0) {
            ret = this.domainUpperBound;
        } else {
            double mean = (double)(this.numberOfSuccesses * this.sampleSize) / (double)(this.numberOfSuccesses + this.numberOfFailures);
            ret = this.findInverseCumulativeProbability(p, this.domainLowerBound, (int)(mean + 0.5), this.domainUpperBound);
        }
        return ret;
    }

    @Override
    public double probability(int x) {
        double ret;
        if (x < this.domainLowerBound || x > this.domainUpperBound) {
            ret = 0.0;
        } else {
            int m = this.numberOfSuccesses + this.numberOfFailures;
            double p = (double)this.sampleSize / (double)m;
            double q = (double)(m - this.sampleSize) / (double)m;
            double p1 = SaddlePointExpansion.logBinomialProbability(x, this.numberOfSuccesses, p, q);
            double p2 = SaddlePointExpansion.logBinomialProbability(this.sampleSize - x, this.numberOfFailures, p, q);
            double p3 = SaddlePointExpansion.logBinomialProbability(this.sampleSize, m, p, q);
            ret = Math.exp(p1 + p2 - p3);
        }
        return ret;
    }

    public void setNumberOfFailures(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("number of failures must be non-negative.");
        }
        this.numberOfFailures = n;
        this.domainLowerBound = Math.max(0, this.sampleSize - this.numberOfFailures);
        this.domainUpperBound = Math.min(this.sampleSize, this.numberOfSuccesses);
    }

    public void setNumberOfSuccesses(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("number of successes must be non-negative.");
        }
        this.numberOfSuccesses = n;
        this.domainUpperBound = Math.min(this.sampleSize, this.numberOfSuccesses);
    }

    public void setSampleSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("sample size must be positive.");
        }
        this.sampleSize = n;
        this.domainLowerBound = Math.max(0, this.sampleSize - this.numberOfFailures);
        this.domainUpperBound = Math.min(this.sampleSize, this.numberOfSuccesses);
    }
}

