/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.statistics.distribution.ContinuousDistribution;

public class ExponentialDistribution
extends ContinuousDistribution {
    private double mean;

    public ExponentialDistribution() {
        this(1.0);
    }

    public ExponentialDistribution(double m) {
        this.setMean(m);
    }

    @Override
    public double cumulativeProbability(double x) {
        double ret = x <= 0.0 ? 0.0 : 1.0 - Math.exp(-x / this.getMean());
        return ret;
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        double ret = p < 0.0 || p > 1.0 || Double.isNaN(p) ? Double.NaN : (p == 0.0 ? 0.0 : (p == 1.0 ? Double.POSITIVE_INFINITY : -this.getMean() * Math.log(1.0 - p)));
        return ret;
    }

    public void setMean(double m) {
        if (m <= 0.0 || Double.isNaN(m)) {
            throw new IllegalArgumentException("Mean must be positive.");
        }
        this.mean = m;
    }
}

