/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.statistics.distribution;

import net.doodleproject.numerics4j.exception.NumericException;
import net.doodleproject.numerics4j.function.Function;
import net.doodleproject.numerics4j.root.BisectionRootFinder;
import net.doodleproject.numerics4j.root.Bracket;
import net.doodleproject.numerics4j.statistics.distribution.Distribution;

public abstract class ContinuousDistribution
implements Distribution {
    public abstract double cumulativeProbability(double var1) throws NumericException;

    public abstract double inverseCumulativeProbability(double var1) throws NumericException;

    protected double findInverseCumulativeProbability(final double p, double lower, double initial, double upper) throws NumericException {
        Function f = new Function(){

            @Override
            public double evaluate(double x) throws NumericException {
                return ContinuousDistribution.this.cumulativeProbability(x) - p;
            }
        };
        Bracket b = new Bracket(f);
        double[] bracket = b.bracketOut(lower, initial, upper);
        BisectionRootFinder bisection = new BisectionRootFinder(f);
        return bisection.findRoot(bracket[0], bracket[1]);
    }
}

