/*
 * Decompiled with CFR 0.152.
 */
package net.doodleproject.numerics4j.continuedfraction;

import net.doodleproject.numerics4j.IterativeMethod;
import net.doodleproject.numerics4j.exception.NumericException;

public abstract class ContinuedFraction
extends IterativeMethod {
    protected ContinuedFraction() {
        this(100, 1.0E-15);
    }

    protected ContinuedFraction(int iterations, double error) {
        super(iterations, error);
    }

    public double evaluate(double x) throws NumericException {
        IterativeState state = new IterativeState(x);
        this.iterate(state);
        return state.getResult();
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    class IterativeState
    implements IterativeMethod.IterativeState {
        private static final double TINY = 1.0E-100;
        private double c;
        private double d;
        private double delta;
        private double f;
        private int n;
        private double x;

        IterativeState(double t) {
            this.x = t;
        }

        @Override
        public int getIterations() {
            return this.n;
        }

        @Override
        public double getRelativeError() {
            return this.delta - 1.0;
        }

        @Override
        public void initialize() {
            this.c = this.f = this.zeroToTiny(ContinuedFraction.this.getA(0, this.x));
            this.d = 0.0;
            this.n = 0;
        }

        @Override
        public void iterate() {
            ++this.n;
            double a = ContinuedFraction.this.getA(this.n, this.x);
            double b = ContinuedFraction.this.getB(this.n, this.x);
            this.d = this.zeroToTiny(a + b * this.d);
            this.c = this.zeroToTiny(a + b / this.c);
            this.d = 1.0 / this.d;
            this.delta = this.c * this.d;
            this.f *= this.delta;
        }

        double getResult() {
            this.iterate();
            return this.f;
        }

        private double zeroToTiny(double t) {
            double ret = t;
            if (t == 0.0) {
                ret = 1.0E-100;
            }
            return ret;
        }
    }
}

