/*
 * Decompiled with CFR 0.152.
 */
package jmathlab.math;

public class Statistics {
    public static double mean(double[] v) {
        double mean = 0.0;
        int m = v.length;
        for (int i = 0; i < m; ++i) {
            mean += v[i];
        }
        return mean /= (double)m;
    }

    public static double[] mean(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] mean = new double[n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                mean[n2] = mean[n2] + v[i][j];
            }
        }
        int j = 0;
        while (j < n) {
            int n3 = j++;
            mean[n3] = mean[n3] / (double)m;
        }
        return mean;
    }

    public static double stddeviation(double[] v) {
        return Math.sqrt(Statistics.variance(v));
    }

    public static double variance(double[] v) {
        int k;
        int degrees = v.length - 1;
        int m = v.length;
        double c = 0.0;
        double s = 0.0;
        for (k = 0; k < m; ++k) {
            s += v[k];
        }
        s /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (v[k] - s) * (v[k] - s);
        }
        double var = c / (double)degrees;
        return var;
    }

    public static double[] stddeviation(double[][] v) {
        double[] var = Statistics.variance(v);
        for (int i = 0; i < var.length; ++i) {
            var[i] = Math.sqrt(var[i]);
        }
        return var;
    }

    public static double[] variance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[] var = new double[n];
        int degrees = m - 1;
        for (int j = 0; j < n; ++j) {
            int k;
            double c = 0.0;
            double s = 0.0;
            for (k = 0; k < m; ++k) {
                s += v[k][j];
            }
            s /= (double)m;
            for (k = 0; k < m; ++k) {
                c += (v[k][j] - s) * (v[k][j] - s);
            }
            var[j] = c / (double)degrees;
        }
        return var;
    }

    public static double covariance(double[] v1, double[] v2) {
        int k;
        int m = v1.length;
        int degrees = m - 1;
        double c = 0.0;
        double s1 = 0.0;
        double s2 = 0.0;
        for (k = 0; k < m; ++k) {
            s1 += v1[k];
            s2 += v2[k];
        }
        s1 /= (double)m;
        s2 /= (double)m;
        for (k = 0; k < m; ++k) {
            c += (v1[k] - s1) * (v2[k] - s2);
        }
        double X = c / (double)degrees;
        return X;
    }

    public static double[][] covariance(double[][] v1, double[][] v2) {
        int m = v1.length;
        int n1 = v1[0].length;
        int n2 = v2[0].length;
        double[][] X = new double[n1][n2];
        int degrees = m - 1;
        for (int i = 0; i < n1; ++i) {
            for (int j = 0; j < n2; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v1[k][i];
                    s2 += v2[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v1[k][i] - s1) * (v2[k][j] - s2);
                }
                X[i][j] = c / (double)degrees;
            }
        }
        return X;
    }

    public static double[][] covariance(double[][] v) {
        int m = v.length;
        int n = v[0].length;
        double[][] X = new double[n][n];
        int degrees = m - 1;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v[k][i];
                    s2 += v[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v[k][i] - s1) * (v[k][j] - s2);
                }
                X[i][j] = c / (double)degrees;
            }
        }
        return X;
    }

    public static double correlation(double[] v1, double[] v2) {
        return Statistics.covariance(v1, v2) / Math.sqrt(Statistics.variance(v1) * Statistics.variance(v2));
    }

    public static double[][] correlation(double[][] v1, double[][] v2) {
        double[] Varv1 = Statistics.variance(v1);
        double[] Varv2 = Statistics.variance(v2);
        double[][] cov = Statistics.covariance(v1, v2);
        for (int i = 0; i < cov.length; ++i) {
            for (int j = 0; j < cov[i].length; ++j) {
                cov[i][j] = cov[i][j] / Math.sqrt(Varv1[i] * Varv2[j]);
            }
        }
        return cov;
    }

    public static double[][] correlation(double[][] v) {
        int j;
        int i;
        int m = v.length;
        int n = v[0].length;
        double[][] X = new double[n][n];
        double[][] V = new double[n][n];
        int degrees = m - 1;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                int k;
                double c = 0.0;
                double s1 = 0.0;
                double s2 = 0.0;
                for (k = 0; k < m; ++k) {
                    s1 += v[k][i];
                    s2 += v[k][j];
                }
                s1 /= (double)m;
                s2 /= (double)m;
                for (k = 0; k < m; ++k) {
                    c += (v[k][i] - s1) * (v[k][j] - s2);
                }
                V[i][j] = c / (double)degrees;
            }
        }
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                X[i][j] = V[i][j] / Math.sqrt(V[i][i] * V[j][j]);
            }
        }
        return X;
    }
}

