/*
 * Decompiled with CFR 0.152.
 */
package jmathlab;

import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import jmathlab.Console;
import jmathlab.RemoteAccessible;
import jmathlab.utils.BrowserLaunch;
import jmatmain.ConsoleService;

public class JPrompt
implements RemoteAccessible,
ClipboardOwner {
    private static final long serialVersionUID = 1L;
    private Console answer;
    private static ConsoleService jasymcaConsole;
    private Thread trun = null;

    @Override
    public void lostOwnership(Clipboard clip, Transferable cont) {
    }

    public JPrompt() {
        jasymcaConsole = new ConsoleService();
        this.answer = new Console(this);
        this.answer.displayPrompt();
        this.answer.requestFocus();
    }

    public JTextPane getTextArea() {
        return this.answer.getComponent();
    }

    @Override
    public void interpretLine(final String s) {
        if (s.equals("help")) {
            String url = "http://jwork.org/jmathlab/";
            this.answer.displayText("% Launching a browser..");
            this.answer.displayPrompt();
            BrowserLaunch.openURL("http://jwork.org/jmathlab/");
            return;
        }
        this.trun = new Thread("Executing a code line"){

            @Override
            public void run() {
                jasymcaConsole.clear();
                String answerString = jasymcaConsole.exec(s);
                JPrompt.this.answer.displayText(answerString);
                JPrompt.this.answer.displayPrompt();
                String serr = jasymcaConsole.getError();
                if (serr.length() > 1) {
                    JPrompt.ErrorMessage(serr);
                }
            }
        };
        this.trun.start();
    }

    private static void ErrorMessage(String a) {
        JOptionPane dialogError = new JOptionPane();
        JOptionPane.showMessageDialog(dialogError, a, "Error", 0);
    }

    public void interpretFile(final String filename) {
        this.trun = new Thread("Executing a file"){

            @Override
            public void run() {
                String out = null;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(filename));
                    String line = null;
                    StringBuilder stringBuilder = new StringBuilder();
                    String ls = System.getProperty("line.separator");
                    try {
                        while ((line = reader.readLine()) != null) {
                            stringBuilder.append(line);
                            stringBuilder.append(ls);
                        }
                        out = stringBuilder.toString();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                if (out == null) {
                    return;
                }
                jasymcaConsole.clear();
                String answerString = jasymcaConsole.exec(out);
                JPrompt.this.answer.displayText(answerString);
                JPrompt.this.answer.displayPrompt();
                String serr = jasymcaConsole.getError();
                if (serr.length() > 1) {
                    JPrompt.ErrorMessage(serr);
                }
            }
        };
        this.trun.start();
    }

    public void setFontText(Font font) {
        this.answer.setFont(font);
    }

    public void clear() {
        jasymcaConsole.clear();
        jasymcaConsole = new ConsoleService();
        this.answer.clear();
    }

    public void displayText(String text) {
        this.answer.displayText(text);
    }

    @Override
    public void close() {
    }
}

