/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.ParseException;
import jasymca.Poly;
import jasymca.StringFmt;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Zahl;
import java.io.PrintStream;
import java.util.Vector;

public class Vektor
extends Algebraic {
    private Algebraic[] a;

    public Vektor(Algebraic[] a) {
        this.a = a;
    }

    public Vektor(Algebraic x, int n) {
        this.a = new Zahl[n];
        for (int i = 0; i < n; ++i) {
            this.a[i] = x;
        }
    }

    public Vektor(int n) {
        this(Zahl.ZERO, n);
    }

    public Vektor(Algebraic c) {
        this.a = c instanceof Vektor ? Poly.clone(((Vektor)c).a) : new Algebraic[]{c};
    }

    public Vektor(double[] x) {
        this.a = new Algebraic[x.length];
        for (int i = 0; i < x.length; ++i) {
            this.a[i] = new Unexakt(x[i]);
        }
    }

    public Vektor(double[] r, double[] i) {
        this.a = new Algebraic[r.length];
        for (int k = 0; k < r.length; ++k) {
            this.a[k] = new Unexakt(r[k], i[k]);
        }
    }

    public static Vektor create(Vector v) throws JasymcaException {
        Algebraic[] a = new Algebraic[v.size()];
        for (int i = 0; i < a.length; ++i) {
            Object x = v.elementAt(i);
            if (!(x instanceof Algebraic)) {
                throw new JasymcaException("Error creating Vektor.");
            }
            a[i] = (Algebraic)x;
        }
        return new Vektor(a);
    }

    public Algebraic get(int i) throws JasymcaException {
        if (i < 0 || i >= this.a.length) {
            throw new JasymcaException("Index out of bounds.");
        }
        return this.a[i];
    }

    public Algebraic[] get() {
        return this.a;
    }

    public Vector vector() {
        Vector<Algebraic> r = new Vector<Algebraic>(this.a.length);
        for (int i = 0; i < this.a.length; ++i) {
            r.addElement(this.a[i]);
        }
        return r;
    }

    public double[] getDouble() throws JasymcaException {
        double[] x = new double[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            Algebraic c = this.a[i];
            if (!(c instanceof Zahl)) {
                throw new JasymcaException("Vector element not constant:" + c);
            }
            x[i] = ((Zahl)c).unexakt().real;
        }
        return x;
    }

    public Vektor reverse() {
        Algebraic[] b = new Algebraic[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            b[i] = this.a[this.a.length - i - 1];
        }
        return new Vektor(b);
    }

    public void set(int i, Algebraic x) throws JasymcaException {
        if (i < 0 || i >= this.a.length) {
            throw new JasymcaException("Index out of bounds.");
        }
        this.a[i] = x;
    }

    public int length() {
        return this.a.length;
    }

    @Override
    public boolean scalarq() {
        return false;
    }

    @Override
    public boolean constantq() {
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i].constantq()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean exaktq() {
        boolean exakt = this.a[0].exaktq();
        for (int i = 1; i < this.a.length; ++i) {
            exakt = exakt && this.a[i].exaktq();
        }
        return exakt;
    }

    @Override
    public Algebraic reduce() {
        if (this.a.length == 1) {
            return this.a[0];
        }
        return this;
    }

    @Override
    public Algebraic cc() throws JasymcaException {
        Algebraic[] b = new Algebraic[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            b[i] = this.a[i].cc();
        }
        return new Vektor(b);
    }

    @Override
    public Algebraic map(LambdaAlgebraic f) throws JasymcaException {
        Algebraic[] cn = new Algebraic[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            cn[i] = f.f_exakt(this.a[i]);
        }
        return new Vektor(cn);
    }

    @Override
    public Algebraic map_lambda(LambdaAlgebraic f, Algebraic arg2) throws ParseException, JasymcaException {
        Algebraic[] b = new Algebraic[this.a.length];
        if (arg2 instanceof Vektor && ((Vektor)arg2).length() == this.a.length) {
            for (int i = 0; i < b.length; ++i) {
                Algebraic c = ((Vektor)arg2).get(i);
                Algebraic r = this.a[i].map_lambda(f, c);
                if (!(r instanceof Algebraic)) {
                    throw new JasymcaException("Cannot evaluate function to algebraic.");
                }
                b[i] = r;
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                Algebraic r = this.a[i].map_lambda(f, arg2);
                if (!(r instanceof Algebraic)) {
                    throw new JasymcaException("Cannot evaluate function to algebraic.");
                }
                b[i] = r;
            }
        }
        return new Vektor(b);
    }

    @Override
    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        Algebraic[] b = new Algebraic[this.a.length];
        for (int i = 0; i < b.length; ++i) {
            b[i] = this.a[i].value(var, x);
        }
        return new Vektor(b);
    }

    @Override
    public Algebraic add(Algebraic x) throws JasymcaException {
        if (x.scalarq()) {
            x = x.promote(this);
        }
        if (x instanceof Vektor && ((Vektor)x).length() == this.a.length) {
            Algebraic[] b = new Algebraic[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                b[i] = this.a[i].add(((Vektor)x).a[i]);
            }
            return new Vektor(b);
        }
        throw new JasymcaException("Wrong Vektor dimension.");
    }

    @Override
    public Algebraic mult(Algebraic x) throws JasymcaException {
        if (x.scalarq()) {
            Algebraic[] b = new Algebraic[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                b[i] = x.mult(this.a[i]);
            }
            return new Vektor(b);
        }
        if (x instanceof Vektor && ((Vektor)x).length() == this.a.length) {
            Algebraic r = Zahl.ZERO;
            for (int i = 0; i < this.a.length; ++i) {
                r = r.add(this.a[i].mult(((Vektor)x).a[i]));
            }
            return r;
        }
        throw new JasymcaException("Wrong Vektor dimension.");
    }

    @Override
    public Algebraic div(Algebraic x) throws JasymcaException {
        if (x.scalarq()) {
            Algebraic[] b = new Algebraic[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                b[i] = this.a[i].div(x);
            }
            return new Vektor(b);
        }
        throw new JasymcaException("Divide not implemented for vektors");
    }

    @Override
    public Algebraic deriv(Variable var) throws JasymcaException {
        Algebraic[] nc = new Algebraic[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            nc[i] = this.a[i].deriv(var);
        }
        return new Vektor(nc);
    }

    @Override
    public Algebraic integrate(Variable var) throws JasymcaException {
        Algebraic[] nc = new Algebraic[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            nc[i] = this.a[i].integrate(var);
        }
        return new Vektor(nc);
    }

    @Override
    public double norm() {
        double r = 0.0;
        for (int i = 0; i < this.a.length; ++i) {
            r += this.a[i].norm();
        }
        return r;
    }

    @Override
    public boolean equals(Object x) {
        if (!(x instanceof Vektor) || ((Vektor)x).a.length != this.a.length) {
            return false;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i].equals(((Vektor)x).a[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String r = "[ ";
        for (int i = 0; i < this.a.length; ++i) {
            r = r + StringFmt.compact(this.a[i].toString());
            if (i >= this.a.length - 1) continue;
            r = r + "  ";
        }
        return r + " ]";
    }

    @Override
    public void print(PrintStream p) {
        p.print("[ ");
        for (int i = 0; i < this.a.length; ++i) {
            String r = StringFmt.compact(this.a[i].toString());
            if (i < this.a.length - 1) {
                r = r + "  ";
            }
            p.print(r);
        }
        p.print(" ]");
    }

    @Override
    public boolean depends(Variable var) {
        for (int i = 0; i < this.a.length; ++i) {
            if (!this.a[i].depends(var)) continue;
            return true;
        }
        return false;
    }
}

