/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Environment;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.ParseException;
import jasymca.SimpleVariable;
import java.util.List;
import java.util.Stack;

class UserProgram
extends Lambda {
    String fname;
    List body;
    SimpleVariable[] var;
    SimpleVariable result;
    Environment env = null;
    Stack ups = null;

    public UserProgram() throws ParseException, JasymcaException {
    }

    public UserProgram(String fname, SimpleVariable[] var, List body, SimpleVariable result, Environment env, Stack ups) {
        this.fname = fname;
        this.var = var;
        this.body = body;
        this.result = result;
        this.env = env;
        this.ups = ups;
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = UserProgram.getNarg(st);
        if (this.var.length != narg) {
            throw new JasymcaException(this.fname + " requires " + this.var.length + " Arguments.");
        }
        for (int i = 0; i < this.var.length; ++i) {
            Object a = st.pop();
            this.env.putValue(this.var[i].name, a);
        }
        int ret = UserProgram.process_block(this.body, this.ups, this.env, this.result != null);
        if (ret != 5) {
            Object y;
            Object object = y = this.result != null ? this.env.getValue(this.result.name) : this.ups.pop();
            if (y instanceof Algebraic && this.result != null) {
                ((Algebraic)y).name = this.result.name;
            }
            if (y != null) {
                st.push(y);
            }
        }
        return 0;
    }

    static int process_block(List code, Stack st, Environment env, boolean clear_stack) {
        int ret;
        Environment global = pc.getEnvironment();
        Stack old_stack = UserProgram.pc.stack;
        pc.setEnvironment(env);
        UserProgram.pc.stack = st;
        try {
            ret = pc.process_list(code, true);
        }
        catch (Exception e) {
            ret = 5;
        }
        UserProgram.pc.stack = old_stack;
        pc.setEnvironment(global);
        if (clear_stack) {
            while (!st.empty()) {
                st.pop();
            }
        }
        return ret;
    }
}

