/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.FunctionVariable;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Poly;
import jasymca.Pzeros;
import jasymca.Rational;
import jasymca.SimpleVariable;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Vector;
import org.apache.commons.math3.util.FastMath;

public class Polynomial
extends Algebraic {
    public Algebraic[] a = null;
    public Variable var = null;
    static boolean loopPartial = false;

    public Polynomial() {
    }

    public Polynomial(Variable var, Algebraic[] a) {
        this.var = var;
        this.a = Poly.reduce(a);
    }

    public Polynomial(Variable var, Vektor v) throws JasymcaException {
        this.var = var;
        this.a = new Algebraic[v.length()];
        for (int i = 0; i < this.a.length; ++i) {
            this.a[i] = v.get(this.a.length - 1 - i);
        }
        this.a = Poly.reduce(this.a);
    }

    public Polynomial(Variable var) {
        this.a = new Zahl[]{Zahl.ZERO, Zahl.ONE};
        this.var = var;
    }

    public Variable getVar() {
        return this.var;
    }

    public Vektor coeff() {
        Algebraic[] c = Poly.clone(this.a);
        return new Vektor(c);
    }

    public Algebraic coefficient(Variable var, int n) throws JasymcaException {
        if (var.equals(this.var)) {
            return this.coefficient(n);
        }
        Algebraic c = Zahl.ZERO;
        for (int i = 0; i < this.a.length; ++i) {
            Algebraic ci = this.a[i];
            if (ci instanceof Polynomial) {
                c = c.add(((Polynomial)ci).coefficient(var, n).mult(new Polynomial(this.var).pow_n(i)));
                continue;
            }
            if (n != 0) continue;
            c = c.add(ci.mult(new Polynomial(this.var).pow_n(i)));
        }
        return c;
    }

    public Algebraic coefficient(int i) throws JasymcaException {
        if (i >= 0 && i < this.a.length) {
            return this.a[i];
        }
        return Zahl.ZERO;
    }

    @Override
    public boolean ratfunc(Variable v) {
        if (this.var instanceof FunctionVariable && ((FunctionVariable)this.var).arg.depends(v)) {
            return false;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i].ratfunc(v)) continue;
            return false;
        }
        return true;
    }

    public int degree() {
        return this.a.length - 1;
    }

    public int degree(Variable v) {
        if (v.equals(this.var)) {
            return this.a.length - 1;
        }
        int degree = 0;
        for (int i = 0; i < this.a.length; ++i) {
            int d = Poly.degree(this.a[i], v);
            if (d <= degree) continue;
            degree = d;
        }
        return degree;
    }

    @Override
    public Algebraic add(Algebraic p) throws JasymcaException {
        if (p instanceof Rational) {
            return p.add(this);
        }
        if (p instanceof Polynomial) {
            if (this.var.equals(((Polynomial)p).var)) {
                int len = FastMath.max((int)this.a.length, (int)((Polynomial)p).a.length);
                Algebraic[] csum = new Algebraic[len];
                for (int i = 0; i < len; ++i) {
                    csum[i] = this.coefficient(i).add(((Polynomial)p).coefficient(i));
                }
                return new Polynomial(this.var, csum).reduce();
            }
            if (this.var.smaller(((Polynomial)p).var)) {
                return p.add(this);
            }
        }
        Algebraic[] csum = Poly.clone(this.a);
        csum[0] = this.a[0].add(p);
        return new Polynomial(this.var, csum).reduce();
    }

    @Override
    public Algebraic mult(Algebraic p) throws JasymcaException {
        if (p instanceof Rational) {
            return p.mult(this);
        }
        if (p instanceof Polynomial) {
            if (this.var.equals(((Polynomial)p).var)) {
                int i;
                int len = this.a.length + ((Polynomial)p).a.length - 1;
                Algebraic[] cprod = new Algebraic[len];
                for (i = 0; i < len; ++i) {
                    cprod[i] = Zahl.ZERO;
                }
                for (i = 0; i < this.a.length; ++i) {
                    for (int k = 0; k < ((Polynomial)p).a.length; ++k) {
                        cprod[i + k] = cprod[i + k].add(this.a[i].mult(((Polynomial)p).a[k]));
                    }
                }
                return new Polynomial(this.var, cprod).reduce();
            }
            if (this.var.smaller(((Polynomial)p).var)) {
                return p.mult(this);
            }
        }
        Algebraic[] cprod = new Algebraic[this.a.length];
        for (int i = 0; i < this.a.length; ++i) {
            cprod[i] = this.a[i].mult(p);
        }
        return new Polynomial(this.var, cprod).reduce();
    }

    @Override
    public Algebraic div(Algebraic q) throws JasymcaException {
        if (q instanceof Zahl) {
            Algebraic[] c = new Algebraic[this.a.length];
            for (int i = 0; i < this.a.length; ++i) {
                c[i] = this.a[i].div(q);
            }
            return new Polynomial(this.var, c);
        }
        return super.div(q);
    }

    @Override
    public Algebraic reduce() throws JasymcaException {
        if (this.a.length == 0) {
            return Zahl.ZERO;
        }
        if (this.a.length == 1) {
            return this.a[0].reduce();
        }
        return this;
    }

    public String toString() {
        Vector<String> x = new Vector<String>();
        for (int i = this.a.length - 1; i > 0; --i) {
            if (this.a[i].equals(Zahl.ZERO)) continue;
            String s = "";
            if (this.a[i].equals(Zahl.MINUS)) {
                s = s + "-";
            } else if (!this.a[i].equals(Zahl.ONE)) {
                s = s + this.a[i].toString() + "*";
            }
            s = s + this.var.toString();
            if (i > 1) {
                s = s + "^" + i;
            }
            x.addElement(s);
        }
        if (!this.a[0].equals(Zahl.ZERO)) {
            x.addElement(this.a[0].toString());
        }
        String s = "";
        if (x.size() > 1) {
            s = s + "(";
        }
        for (int i = 0; i < x.size(); ++i) {
            s = s + (String)x.elementAt(i);
            if (i >= x.size() - 1 || ((String)x.elementAt(i + 1)).charAt(0) == '-') continue;
            s = s + "+";
        }
        if (x.size() > 1) {
            s = s + ")";
        }
        return s;
    }

    @Override
    public boolean equals(Object x) {
        if (!(x instanceof Polynomial)) {
            return false;
        }
        if (!this.var.equals(((Polynomial)x).var) || this.a.length != ((Polynomial)x).a.length) {
            return false;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (this.a[i].equals(((Polynomial)x).a[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public Algebraic deriv(Variable var) throws JasymcaException {
        int i;
        Algebraic r1 = Zahl.ZERO;
        Algebraic r2 = Zahl.ZERO;
        Polynomial x = new Polynomial(this.var);
        for (i = this.a.length - 1; i > 1; --i) {
            r1 = r1.add(this.a[i].mult(new Unexakt(i))).mult(x);
        }
        if (this.a.length > 1) {
            r1 = r1.add(this.a[1]);
        }
        for (i = this.a.length - 1; i > 0; --i) {
            r2 = r2.add(this.a[i].deriv(var)).mult(x);
        }
        if (this.a.length > 0) {
            r2 = r2.add(this.a[0].deriv(var));
        }
        return r1.mult(this.var.deriv(var)).add(r2).reduce();
    }

    @Override
    public boolean depends(Variable var) {
        if (this.a.length == 0) {
            return false;
        }
        if (this.var.equals(var)) {
            return true;
        }
        if (this.var instanceof FunctionVariable && ((FunctionVariable)this.var).arg.depends(var)) {
            return true;
        }
        for (int i = 0; i < this.a.length; ++i) {
            if (!this.a[i].depends(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Algebraic integrate(Variable var) throws JasymcaException {
        Algebraic in = Zahl.ZERO;
        for (int i = 1; i < this.a.length; ++i) {
            if (!this.a[i].depends(var)) {
                if (var.equals(this.var)) {
                    in = in.add(this.a[i].mult(new Polynomial(var).pow_n(i + 1).div(new Unexakt(i + 1))));
                    continue;
                }
                if (this.var instanceof FunctionVariable && ((FunctionVariable)this.var).arg.depends(var)) {
                    if (i == 1) {
                        in = in.add(((FunctionVariable)this.var).integrate(var).mult(this.a[1]));
                        continue;
                    }
                    throw new JasymcaException("Integral not supported.");
                }
                in = in.add(this.a[i].mult(new Polynomial(var).mult(new Polynomial(this.var).pow_n(i))));
                continue;
            }
            if (var.equals(this.var)) {
                throw new JasymcaException("Integral not supported.");
            }
            if (this.var instanceof FunctionVariable && ((FunctionVariable)this.var).arg.depends(var)) {
                if (i == 1 && this.a[i] instanceof Polynomial && ((Polynomial)this.a[i]).var.equals(var)) {
                    Algebraic r;
                    Algebraic f;
                    Algebraic p;
                    Polynomial.p("Trying to isolate inner derivative " + this);
                    try {
                        FunctionVariable f2 = (FunctionVariable)this.var;
                        Algebraic w = f2.arg;
                        Algebraic q = this.a[i].div(w.deriv(var));
                        if (q.deriv(var).equals(Zahl.ZERO)) {
                            SimpleVariable v = new SimpleVariable("v");
                            Algebraic p2 = FunctionVariable.create(f2.fname, new Polynomial(v));
                            Algebraic r2 = p2.integrate(v).value(v, w).mult(q);
                            in = in.add(r2);
                            continue;
                        }
                    }
                    catch (JasymcaException f2) {
                        // empty catch block
                    }
                    Polynomial.p("Failed.");
                    for (int k = 0; k < ((Polynomial)this.a[i]).a.length; ++k) {
                        if (!((Polynomial)this.a[i]).a[k].depends(var)) continue;
                        throw new JasymcaException("Function not supported by this method");
                    }
                    if (loopPartial) {
                        loopPartial = false;
                        Polynomial.p("Partial Integration Loop detected.");
                        throw new JasymcaException("Partial Integration Loop: " + this);
                    }
                    Polynomial.p("Trying partial integration: x^n*f(x) , n-times diff " + this);
                    try {
                        loopPartial = true;
                        p = this.a[i];
                        f = ((FunctionVariable)this.var).integrate(var);
                        r = f.mult(p);
                        while (!(p = p.deriv(var)).equals(Zahl.ZERO)) {
                            f = f.integrate(var).mult(Zahl.MINUS);
                            r = r.add(f.mult(p));
                        }
                        loopPartial = false;
                        in = in.add(r);
                        continue;
                    }
                    catch (JasymcaException je) {
                        loopPartial = false;
                        Polynomial.p("Failed.");
                        Polynomial.p("Trying partial integration: x^n*f(x) , 1-times int " + this);
                        try {
                            loopPartial = true;
                            p = this.a[i].integrate(var);
                            f = new Polynomial((FunctionVariable)this.var);
                            r = p.mult(f).sub(p.mult(f.deriv(var)).integrate(var));
                            loopPartial = false;
                            in = in.add(r);
                            continue;
                        }
                        catch (JasymcaException je3) {
                            loopPartial = false;
                            Polynomial.p("Failed");
                            throw new JasymcaException("Function not supported by this method");
                        }
                    }
                }
                throw new JasymcaException("Integral not supported.");
            }
            in = in.add(this.a[i].integrate(var).mult(new Polynomial(this.var).pow_n(i)));
        }
        if (this.a.length > 0) {
            in = in.add(this.a[0].integrate(var));
        }
        return in;
    }

    @Override
    public Algebraic cc() throws JasymcaException {
        Polynomial xn = new Polynomial(this.var.cc());
        Algebraic r = Zahl.ZERO;
        for (int i = this.a.length - 1; i > 0; --i) {
            r = r.add(this.a[i].cc()).mult(xn);
        }
        if (this.a.length > 0) {
            r = r.add(this.a[0].cc());
        }
        return r;
    }

    @Override
    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        Algebraic r = Zahl.ZERO;
        Algebraic v = this.var.value(var, x);
        for (int i = this.a.length - 1; i > 0; --i) {
            r = r.add(this.a[i].value(var, x)).mult(v);
        }
        if (this.a.length > 0) {
            r = r.add(this.a[0].value(var, x));
        }
        return r;
    }

    public Algebraic value(Algebraic x) throws JasymcaException {
        return this.value(this.var, x);
    }

    @Override
    public boolean exaktq() {
        boolean exakt = this.a[0].exaktq();
        for (int i = 1; i < this.a.length; ++i) {
            exakt = exakt && this.a[i].exaktq();
        }
        return exakt;
    }

    @Override
    public double norm() {
        double norm = 0.0;
        for (int i = 0; i < this.a.length; ++i) {
            norm += this.a[i].norm();
        }
        return norm;
    }

    @Override
    public Algebraic map(LambdaAlgebraic f) throws JasymcaException {
        Polynomial x = this.var instanceof SimpleVariable ? new Polynomial(this.var) : FunctionVariable.create(((FunctionVariable)this.var).fname, f.f_exakt(((FunctionVariable)this.var).arg));
        Algebraic r = Zahl.ZERO;
        for (int i = this.a.length - 1; i > 0; --i) {
            r = r.add(f.f_exakt(this.a[i])).mult(x);
        }
        if (this.a.length > 0) {
            r = r.add(f.f_exakt(this.a[0]));
        }
        return r;
    }

    public Polynomial monic() throws JasymcaException {
        Algebraic cm = this.a[this.a.length - 1];
        if (cm.equals(Zahl.ONE)) {
            return this;
        }
        if (cm.equals(Zahl.ZERO) || cm.depends(this.var)) {
            throw new JasymcaException("Ill conditioned polynomial: main coefficient Zero or not number");
        }
        Algebraic[] b = new Algebraic[this.a.length];
        b[this.a.length - 1] = Zahl.ONE;
        for (int i = 0; i < this.a.length - 1; ++i) {
            b[i] = this.a[i].div(cm);
        }
        return new Polynomial(this.var, b);
    }

    public Algebraic[] square_free_dec(Variable var) throws JasymcaException {
        if (!this.ratfunc(var)) {
            return null;
        }
        Algebraic dp = this.deriv(var);
        Algebraic gcd_pdp = Poly.poly_gcd(this, dp);
        Algebraic q = Poly.polydiv(this, gcd_pdp);
        Algebraic p1 = Poly.polydiv(q, Poly.poly_gcd(q, gcd_pdp));
        if (gcd_pdp instanceof Polynomial && gcd_pdp.depends(var) && ((Polynomial)gcd_pdp).ratfunc(var)) {
            Algebraic[] sq = ((Polynomial)gcd_pdp).square_free_dec(var);
            Algebraic[] result = new Algebraic[sq.length + 1];
            result[0] = p1;
            for (int i = 0; i < sq.length; ++i) {
                result[i + 1] = sq[i];
            }
            return result;
        }
        Algebraic[] result = new Algebraic[]{p1};
        return result;
    }

    public Zahl gcd_coeff() throws JasymcaException {
        Zahl gcd;
        if (this.a[0] instanceof Zahl) {
            gcd = (Zahl)this.a[0];
        } else if (this.a[0] instanceof Polynomial) {
            gcd = ((Polynomial)this.a[0]).gcd_coeff();
        } else {
            throw new JasymcaException("Cannot calculate gcd from " + this);
        }
        for (int i = 1; i < this.a.length; ++i) {
            if (this.a[i] instanceof Zahl) {
                gcd = gcd.gcd((Zahl)this.a[i]);
                continue;
            }
            if (this.a[i] instanceof Polynomial) {
                gcd = gcd.gcd(((Polynomial)this.a[i]).gcd_coeff());
                continue;
            }
            throw new JasymcaException("Cannot calculate gcd from " + this);
        }
        return gcd;
    }

    public Vektor solve(Variable var) throws JasymcaException {
        if (!var.equals(this.var)) {
            return ((Polynomial)this.value(var, Poly.top)).solve(SimpleVariable.top);
        }
        Algebraic[] factors = this.square_free_dec(var);
        Vector<Algebraic> s = new Vector<Algebraic>();
        int n = factors == null ? 0 : factors.length;
        for (int i = 0; i < n; ++i) {
            if (!(factors[i] instanceof Polynomial)) continue;
            Vektor sol = null;
            Algebraic equ = factors[i];
            try {
                sol = ((Polynomial)equ).solvepoly();
            }
            catch (JasymcaException je) {
                sol = ((Polynomial)equ).monic().roots();
            }
            for (int k = 0; k < sol.length(); ++k) {
                s.addElement(sol.get(k));
            }
        }
        Algebraic[] cn = new Algebraic[s.size()];
        for (int i = 0; i < cn.length; ++i) {
            cn[i] = (Algebraic)s.elementAt(i);
        }
        return new Vektor(cn);
    }

    public Vektor solvepoly() throws JasymcaException {
        Vector<Algebraic> s = new Vector<Algebraic>();
        switch (this.degree()) {
            case 0: {
                break;
            }
            case 1: {
                s.addElement(Zahl.MINUS.mult(this.a[0].div(this.a[1])));
                break;
            }
            case 2: {
                Algebraic p = this.a[1].div(this.a[2]);
                Algebraic q = this.a[0].div(this.a[2]);
                p = Zahl.MINUS.mult(p).div(Zahl.TWO);
                q = p.mult(p).sub(q);
                if (q.equals(Zahl.ZERO)) {
                    s.addElement(p);
                    break;
                }
                q = FunctionVariable.create("sqrt", q);
                s.addElement(p.add(q));
                s.addElement(p.sub(q));
                break;
            }
            default: {
                int gcd = -1;
                for (int i = 1; i < this.a.length; ++i) {
                    if (this.a[i].equals(Zahl.ZERO)) continue;
                    gcd = gcd < 0 ? i : Poly.gcd(i, gcd);
                }
                int deg = this.degree() / gcd;
                if (deg < 3) {
                    Algebraic[] cn = new Algebraic[deg + 1];
                    for (int i = 0; i < cn.length; ++i) {
                        cn[i] = this.a[i * gcd];
                    }
                    Polynomial pr = new Polynomial(this.var, cn);
                    Vektor sn = pr.solvepoly();
                    if (gcd == 2) {
                        cn = new Algebraic[sn.length() * 2];
                        for (int i = 0; i < sn.length(); ++i) {
                            cn[2 * i] = FunctionVariable.create("sqrt", sn.get(i));
                            cn[2 * i + 1] = cn[2 * i].mult(Zahl.MINUS);
                        }
                    } else {
                        cn = new Algebraic[sn.length()];
                        Unexakt wx = new Unexakt(1.0 / (double)gcd);
                        for (int i = 0; i < sn.length(); ++i) {
                            Algebraic exp = FunctionVariable.create("log", sn.get(i));
                            cn[i] = FunctionVariable.create("exp", exp.mult(wx));
                        }
                    }
                    return new Vektor(cn);
                }
                throw new JasymcaException("Can't solve expression " + this);
            }
        }
        return Vektor.create(s);
    }

    public Vektor roots() throws JasymcaException {
        if (this.a.length == 2) {
            Algebraic[] result = new Algebraic[]{this.a[0].mult(Zahl.MINUS).div(this.a[1])};
            return new Vektor(result);
        }
        if (this.a.length == 3) {
            return new Vektor(Poly.pqsolve(this.a[1].div(this.a[2]), this.a[0].div(this.a[2])));
        }
        double[] ar = new double[this.a.length];
        double[] ai = new double[this.a.length];
        boolean[] err = new boolean[this.a.length];
        boolean komplex = false;
        for (int i = 0; i < this.a.length; ++i) {
            Algebraic cf = this.a[i];
            if (!(cf instanceof Zahl)) {
                throw new JasymcaException("Roots requires constant coefficients.");
            }
            ar[i] = ((Zahl)cf).unexakt().real;
            ai[i] = ((Zahl)cf).unexakt().imag;
            if (ai[i] == 0.0) continue;
            komplex = true;
        }
        if (komplex) {
            Pzeros.aberth(ar, ai, err);
        } else {
            int i;
            Pzeros.bairstow(ar, ai, err);
            boolean ok = true;
            for (i = 0; i < err.length - 1; ++i) {
                if (!err[i]) continue;
                ok = false;
            }
            if (!ok) {
                for (i = 0; i < this.a.length; ++i) {
                    Algebraic cf = this.a[i];
                    ar[i] = ((Zahl)cf).unexakt().real;
                    ai[i] = ((Zahl)cf).unexakt().imag;
                }
                Pzeros.aberth(ar, ai, err);
            }
        }
        Algebraic[] r = new Algebraic[this.a.length - 1];
        for (int i = 0; i < r.length; ++i) {
            if (err[i]) {
                throw new JasymcaException("Could not calculate root " + i);
            }
            Unexakt x0 = new Unexakt(ar[i], ai[i]);
            r[i] = x0;
        }
        return new Vektor(r);
    }
}

