/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Constants;
import jasymca.Lambda;

public class Operator
implements Constants {
    String mnemonic;
    String symbol;
    int precedence;
    int associativity;
    int type;
    Lambda func = null;
    static Operator[] OPS = new Operator[0];

    public boolean unary() {
        return (this.type & 1) != 0;
    }

    public boolean binary() {
        return (this.type & 2) != 0;
    }

    public boolean ternary() {
        return (this.type & 4) != 0;
    }

    public boolean lvalue() {
        return (this.type & 8) != 0;
    }

    public boolean list() {
        return (this.type & 0x10) != 0;
    }

    public boolean left_right() {
        return this.associativity == 0;
    }

    public Operator(String mnemonic, String symbol, int precedence, int associativity, int type) {
        this.mnemonic = mnemonic;
        this.symbol = symbol;
        this.precedence = precedence;
        this.associativity = associativity;
        this.type = type;
    }

    public String toString() {
        return this.symbol;
    }

    static Operator get(Object text_in) {
        if (!(text_in instanceof String)) {
            return null;
        }
        String text = (String)text_in;
        for (int k = 0; k < OPS.length; ++k) {
            Operator op = OPS[k];
            if (!text.startsWith(op.symbol)) continue;
            return op;
        }
        return null;
    }

    static Operator get(Object text_in, int pos) {
        if (!(text_in instanceof String)) {
            return null;
        }
        String text = (String)text_in;
        block5: for (int k = 0; k < OPS.length; ++k) {
            Operator op = OPS[k];
            if (!text.startsWith(op.symbol)) continue;
            switch (pos) {
                case 0: {
                    if (!op.unary() || !op.left_right()) continue block5;
                    return op;
                }
                case 2: {
                    if (!op.unary() || op.left_right()) continue block5;
                    return op;
                }
                case 1: {
                    if (!op.binary() && !op.ternary()) continue block5;
                    return op;
                }
            }
        }
        return null;
    }

    Lambda getLambda() {
        if (this.func == null) {
            try {
                Class<?> c = Class.forName("jasymca." + this.mnemonic);
                this.func = (Lambda)c.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.func;
    }
}

