/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.NumFmt;

class NumFmtVar
implements NumFmt {
    double base;
    int ibase;
    int nsign;
    double mantisse_min;
    double mantisse_max;

    public NumFmtVar(int ibase, int nsign) {
        this.base = ibase;
        this.ibase = ibase;
        this.nsign = nsign;
        this.mantisse_min = 1.0;
        while (nsign-- > 0) {
            this.mantisse_min *= this.base;
        }
        this.mantisse_max = this.mantisse_min * this.base;
    }

    @Override
    public String toString(double x) {
        if (x < 0.0) {
            return "-" + this.toString(-x);
        }
        if (x == 0.0) {
            return "0";
        }
        int exp = this.nsign - 1;
        while (x < this.mantisse_min) {
            --exp;
            x *= this.base;
        }
        while (x >= this.mantisse_min) {
            ++exp;
            x /= this.base;
        }
        String r = "";
        int nc = this.nsign;
        for (long xl = Math.round(x); xl != 0L; xl /= (long)this.ibase) {
            --nc;
            int digit = this.digit(xl % (long)this.ibase);
            if (r.equals("") && digit == 48) continue;
            r = (char)digit + r;
        }
        if ((exp -= nc) > this.nsign - 1 || exp < -1) {
            if (r.length() == 1) {
                r = r + "0";
            }
            return this.sub(r, 0, 1) + "." + this.sub(r, 1, r.length()) + "E" + exp;
        }
        if (exp == -1) {
            return "0." + r;
        }
        return this.sub(r, 0, exp + 1) + (r.length() > exp + 1 ? "." + this.sub(r, exp + 1, r.length()) : "");
    }

    private int digit(long x) {
        if (x < 10L) {
            return 48 + (int)x;
        }
        return 65 + (int)x - 10;
    }

    String sub(String s, int a, int b) {
        if (s.length() >= b) {
            return s.substring(a, b);
        }
        String r = "";
        while (a < b) {
            r = a < s.length() ? r + s.charAt(a) : r + "0";
            ++a;
        }
        return r;
    }
}

