/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Unexakt;
import jasymca.Zahl;

class LambdaSIN
extends LambdaAlgebraic {
    public LambdaSIN() {
        this.diffrule = "cos(x)";
        this.intrule = "-cos(x)";
        this.trigrule = "1/(2*i)*(exp(i*x)-exp(-i*x))";
    }

    @Override
    Zahl f(Zahl x) throws JasymcaException {
        Unexakt z = x.unexakt();
        if (z.imag == 0.0) {
            return new Unexakt(Math.sin(z.real));
        }
        return (Zahl)LambdaSIN.evalx(this.trigrule, z);
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        if (x.equals(Zahl.ZERO)) {
            return Zahl.ZERO;
        }
        return null;
    }
}

