/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.Matrix;
import jasymca.ParseException;
import java.util.Stack;
import org.netlib.lapack.DGEQRF;
import org.netlib.lapack.DORGQR;
import org.netlib.lapack.DORMQR;
import org.netlib.util.intW;

class LambdaQR
extends LambdaAlgebraic {
    LambdaQR() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        try {
            Class<?> clazz = Class.forName("org.netlib.lapack.DGEQRF");
        }
        catch (ClassNotFoundException ce) {
            throw new JasymcaException("JLAPACK not available.");
        }
        int narg = LambdaQR.getNarg(st);
        if (narg != 1) {
            throw new JasymcaException("Usage: QR( A ).");
        }
        Matrix mx = new Matrix(LambdaQR.getAlgebraic(st));
        double[][] a = mx.getDouble();
        int m = mx.nrow();
        int n = mx.ncol();
        if (n > m) {
            throw new JasymcaException("QR-factorization requires n<=m");
        }
        double[] tau = new double[Math.min(m, n)];
        int lwork = n;
        double[] work = new double[lwork];
        intW info = new intW(1);
        DGEQRF.DGEQRF((int)m, (int)n, (double[][])a, (double[])tau, (double[])work, (int)lwork, (intW)info);
        if (info.val != 0) {
            throw new JasymcaException("jlapack DGEQRF failed.");
        }
        int k = Math.min(n, m);
        double[][] c = mx.getDouble();
        DORMQR.DORMQR((String)"L", (String)"T", (int)m, (int)n, (int)k, (double[][])a, (double[])tau, (double[][])c, (double[])work, (int)lwork, (intW)info);
        if (info.val != 0) {
            throw new JasymcaException("jlapack DORMQR failed.");
        }
        DORGQR.DORGQR((int)m, (int)n, (int)k, (double[][])a, (double[])tau, (double[])work, (int)lwork, (intW)info);
        if (info.val != 0) {
            throw new JasymcaException("jlapack DORGQR failed.");
        }
        for (int i = 0; i < c.length; ++i) {
            for (int j = 0; j < i && j < c[0].length; ++j) {
                c[i][j] = 0.0;
            }
        }
        if (length != 2) {
            throw new JasymcaException("Wrong number of output variables: " + length);
        }
        st.push(new Matrix(a).reduce());
        st.push(new Matrix(c).reduce());
        length = 1;
        return 0;
    }
}

