/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Exakt;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Vektor;
import jasymca.Zahl;
import java.math.BigInteger;
import java.util.Stack;
import java.util.Vector;

public class LambdaPRIMES
extends Lambda {
    static final int[] mod = new int[]{1, 7, 11, 13, 17, 19, 23, 29};
    static final int[] moddif = new int[]{1, 6, 4, 2, 4, 2, 4, 6};

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaPRIMES.getNarg(st);
        Algebraic x = LambdaPRIMES.getAlgebraic(st);
        if (!(x instanceof Zahl) && !((Zahl)x).integerq()) {
            throw new JasymcaException("Expected integer argument.");
        }
        if (((Zahl)x).smaller(Zahl.ZERO)) {
            x = x.mult(Zahl.MINUS);
        }
        Vektor res = null;
        if (x instanceof Unexakt) {
            long xl = (long)((Zahl)x).unexakt().real;
            res = LambdaPRIMES.teiler(xl);
        } else {
            BigInteger xb = ((Exakt)x).real[0];
            if (xb.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                long xl = xb.longValue();
                res = LambdaPRIMES.teiler(xl);
            } else {
                res = LambdaPRIMES.teiler(xb);
            }
        }
        if (res != null) {
            st.push(res);
        }
        return 0;
    }

    static long kleinsterTeiler(long X, long start) {
        long stop = (long)Math.ceil(Math.sqrt(X));
        if (start > stop) {
            return X;
        }
        long b = start / 30L;
        b *= 30L;
        long m = start % 30L;
        int i = 0;
        while (m > (long)mod[i]) {
            ++i;
        }
        while (start <= stop) {
            if (pc.check_interrupt()) {
                return -1L;
            }
            if (X % start == 0L) {
                return start;
            }
            if (++i >= mod.length) {
                i = 0;
                start = b += 30L;
            }
            start += (long)moddif[i];
        }
        return X;
    }

    static Vektor teiler(long X) throws JasymcaException {
        Vector<Zahl> teiler = new Vector<Zahl>();
        while (X % 2L == 0L) {
            teiler.addElement(Zahl.TWO);
            X /= 2L;
        }
        while (X % 3L == 0L) {
            teiler.addElement(Zahl.THREE);
            X /= 3L;
        }
        while (X % 5L == 0L) {
            teiler.addElement(new Unexakt(5.0));
            X /= 5L;
        }
        long f = 7L;
        while (X != 1L) {
            if ((f = LambdaPRIMES.kleinsterTeiler(X, f)) < 0L) {
                return null;
            }
            teiler.addElement(new Exakt(f, 1L));
            X /= f;
        }
        return Vektor.create(teiler);
    }

    static BigInteger kleinsterTeiler(BigInteger X, BigInteger start) {
        byte[] stop_in = new byte[X.bitLength() / 2 + 1];
        stop_in[0] = 1;
        for (int i = 1; i < stop_in.length; ++i) {
            stop_in[i] = 0;
        }
        BigInteger stop = new BigInteger(stop_in);
        if (start.compareTo(stop) > 0) {
            return X;
        }
        BigInteger b30 = BigInteger.valueOf(30L);
        BigInteger b = start.divide(b30);
        b = b.multiply(b30);
        int m = start.mod(b30).intValue();
        int i = 0;
        while (m > mod[i]) {
            ++i;
        }
        while (start.compareTo(stop) <= 0) {
            if (pc.check_interrupt()) {
                return null;
            }
            if (X.mod(start).equals(BigInteger.ZERO)) {
                return start;
            }
            if (++i >= mod.length) {
                i = 0;
                start = b = b.add(b30);
            }
            start = start.add(BigInteger.valueOf(moddif[i]));
        }
        return X;
    }

    static Vektor teiler(BigInteger X) throws JasymcaException {
        Vector<Zahl> teiler = new Vector<Zahl>();
        BigInteger b2 = BigInteger.valueOf(2L);
        while (X.mod(b2).equals(BigInteger.ZERO)) {
            teiler.addElement(Zahl.TWO);
            X = X.divide(b2);
        }
        BigInteger b3 = BigInteger.valueOf(3L);
        while (X.mod(b3).equals(BigInteger.ZERO)) {
            teiler.addElement(Zahl.THREE);
            X = X.divide(b3);
        }
        BigInteger b5 = BigInteger.valueOf(5L);
        while (X.mod(b5).equals(BigInteger.ZERO)) {
            teiler.addElement(new Unexakt(5.0));
            X = X.divide(b5);
        }
        BigInteger f = BigInteger.valueOf(7L);
        while (!X.equals(BigInteger.ONE)) {
            if ((f = LambdaPRIMES.kleinsterTeiler(X, f)) == null) {
                return null;
            }
            teiler.addElement(new Exakt(f));
            X = X.divide(f);
        }
        return Vektor.create(teiler);
    }
}

