/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;

public class LambdaLINSOLVE
extends Lambda {
    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaLINSOLVE.getNarg(st);
        if (narg != 2) {
            throw new ParseException("linsolve requires 2 arguments.");
        }
        Algebraic M_in = LambdaLINSOLVE.getAlgebraic(st);
        Algebraic b_in = LambdaLINSOLVE.getAlgebraic(st);
        Matrix M = new Matrix(M_in);
        Matrix b = b_in instanceof Vektor ? Matrix.column((Vektor)b_in) : new Matrix(b_in);
        Algebraic r = ((Matrix)b.transpose().div(M.transpose())).transpose().reduce();
        st.push(r);
        return 0;
    }

    public int lambda2(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaLINSOLVE.getNarg(st);
        if (narg != 2) {
            throw new ParseException("linsolve requires 2 arguments.");
        }
        Vektor expr = (Vektor)LambdaLINSOLVE.getVektor(st).rat();
        Vektor vars = LambdaLINSOLVE.getVektor(st);
        LambdaLINSOLVE.elim(expr, vars, 0);
        LambdaLINSOLVE.subst(expr, vars, expr.length() - 1);
        st.push(expr);
        return 0;
    }

    private static void subst(Vektor expr, Vektor vars, int n) throws JasymcaException {
        if (n < 0) {
            return;
        }
        Algebraic pa = expr.get(n);
        if (pa instanceof Polynomial) {
            Polynomial p = (Polynomial)pa;
            Variable v = null;
            Algebraic c1 = null;
            for (int k = 0; k < vars.length(); ++k) {
                Variable va = ((Polynomial)vars.get((int)k)).var;
                c1 = p.coefficient(va, 1);
                if (c1.equals(Zahl.ZERO)) continue;
                v = va;
                break;
            }
            if (v != null) {
                expr.set(n, p.div(c1));
                Algebraic val = p.coefficient(v, 0).mult(Zahl.MINUS).div(c1);
                for (int k = 0; k < n; ++k) {
                    Algebraic ps = expr.get(k);
                    if (!(ps instanceof Polynomial)) continue;
                    expr.set(k, ((Polynomial)ps).value(v, val));
                }
            }
        }
        LambdaLINSOLVE.subst(expr, vars, n - 1);
    }

    private static void elim(Vektor expr, Vektor vars, int n) throws JasymcaException {
        int i;
        if (n >= expr.length()) {
            return;
        }
        double maxc = 0.0;
        int iv = 0;
        int ie = 0;
        Variable vp = null;
        Algebraic f = Zahl.ONE;
        Polynomial pm = null;
        for (i = 0; i < vars.length(); ++i) {
            Variable v = ((Polynomial)vars.get((int)i)).var;
            for (int k = n; k < expr.length(); ++k) {
                Polynomial p;
                Algebraic c;
                double nm;
                Algebraic pa = expr.get(k);
                if (!(pa instanceof Polynomial) || !((nm = (c = (p = (Polynomial)pa).coefficient(v, 1)).norm()) > maxc)) continue;
                maxc = nm;
                vp = v;
                ie = k;
                iv = i;
                f = c;
                pm = p;
            }
        }
        if (maxc == 0.0) {
            return;
        }
        expr.set(ie, expr.get(n));
        expr.set(n, pm);
        for (i = n + 1; i < expr.length(); ++i) {
            Algebraic fc;
            Algebraic p = expr.get(i);
            if (p instanceof Polynomial && !(fc = ((Polynomial)p).coefficient(vp, 1)).equals(Zahl.ZERO)) {
                p = p.sub(pm.mult(fc.div(f)));
            }
            expr.set(i, p);
        }
        LambdaLINSOLVE.elim(expr, vars, n + 1);
    }

    private static void eliminierung(Matrix a, Vektor c) throws JasymcaException {
        int n = c.length();
        for (int k = 0; k < n - 1; ++k) {
            LambdaLINSOLVE.pivot(a, c, k);
            for (int i = k + 1; i < n; ++i) {
                Algebraic factor = a.get(i, k).div(a.get(k, k));
                for (int j = k; j < n; ++j) {
                    a.set(i, j, a.get(i, j).sub(factor.mult(a.get(k, j))));
                }
                c.set(i, c.get(i).sub(factor.mult(c.get(k))));
            }
        }
    }

    public static Vektor substitution(Matrix a, Vektor c) throws JasymcaException {
        int n = c.length();
        Algebraic[] x = new Algebraic[n];
        x[n - 1] = c.get(n - 1).div(a.get(n - 1, n - 1));
        for (int i = n - 2; i >= 0; --i) {
            Algebraic sum = Zahl.ZERO;
            for (int j = i + 1; j < n; ++j) {
                sum = sum.add(a.get(i, j).mult(x[j]));
            }
            x[i] = c.get(i).sub(sum).div(a.get(i, i));
        }
        return new Vektor(x);
    }

    public static Vektor Gauss(Matrix a, Vektor c) throws JasymcaException {
        int n = c.length();
        Algebraic[] x = new Algebraic[n];
        for (int k = 0; k < n - 1; ++k) {
            LambdaLINSOLVE.pivot(a, c, k);
            if (a.get(k, k).equals(Zahl.ZERO)) continue;
            for (int i = k + 1; i < n; ++i) {
                Algebraic factor = a.get(i, k).div(a.get(k, k));
                for (int j = k + 1; j < n; ++j) {
                    a.set(i, j, a.get(i, j).sub(factor.mult(a.get(k, j))));
                }
                c.set(i, c.get(i).sub(factor.mult(c.get(k))));
            }
        }
        x[n - 1] = c.get(n - 1).div(a.get(n - 1, n - 1));
        for (int i = n - 2; i >= 0; --i) {
            Algebraic sum = Zahl.ZERO;
            for (int j = i + 1; j < n; ++j) {
                sum = sum.add(a.get(i, j).mult(x[j]));
            }
            x[i] = c.get(i).sub(sum).div(a.get(i, i));
        }
        return new Vektor(x);
    }

    private static int pivot(Matrix a, Vektor c, int k) throws JasymcaException {
        int pivot = k;
        int n = c.length();
        double maxa = a.get(k, k).norm();
        for (int i = k + 1; i < n; ++i) {
            double dummy = a.get(i, k).norm();
            if (!(dummy > maxa)) continue;
            maxa = dummy;
            pivot = i;
        }
        if (pivot != k) {
            for (int j = k; j < n; ++j) {
                Algebraic dummy = a.get(pivot, j);
                a.set(pivot, j, a.get(k, j));
                a.set(k, j, dummy);
            }
            Algebraic dummy = c.get(pivot);
            c.set(pivot, c.get(k));
            c.set(k, dummy);
        }
        return pivot;
    }
}

