/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.ExpandUser;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaRAT;
import jasymca.NormExp;
import jasymca.ParseException;
import jasymca.Poly;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.SubstExp;
import jasymca.TrigExpand;
import jasymca.TrigInverseExpand;
import jasymca.Variable;
import jasymca.Zahl;
import java.util.Stack;

class LambdaINTEGRATE
extends Lambda {
    LambdaINTEGRATE() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        Variable v;
        int narg = LambdaINTEGRATE.getNarg(st);
        if (narg == 0) {
            throw new ParseException("Argument to integrate missing.");
        }
        Algebraic f = LambdaINTEGRATE.getAlgebraic(st);
        if (narg > 1) {
            v = LambdaINTEGRATE.getVariable(st);
        } else if (f instanceof Polynomial) {
            v = ((Polynomial)f).var;
        } else if (f instanceof Rational) {
            v = ((Rational)f).den.var;
        } else {
            throw new ParseException("Could not determine Variable.");
        }
        Algebraic fi = LambdaINTEGRATE.integrate(f, v);
        if (fi instanceof Rational && !fi.exaktq()) {
            fi = new LambdaRAT().f_exakt(fi);
        }
        st.push(fi);
        return 0;
    }

    public static Algebraic integrate(Algebraic expr, Variable v) throws JasymcaException {
        Algebraic e = new ExpandUser().f_exakt(expr);
        try {
            e = e.integrate(v);
            e = new TrigInverseExpand().f_exakt(e);
            e = LambdaINTEGRATE.remove_constant(e, v);
            return e;
        }
        catch (JasymcaException jasymcaException) {
            LambdaINTEGRATE.p("Second Attempt: " + expr);
            expr = new ExpandUser().f_exakt(expr);
            LambdaINTEGRATE.p("Expand User Functions: " + expr);
            e = expr = new TrigExpand().f_exakt(expr);
            try {
                expr = new NormExp().f_exakt(expr);
                LambdaINTEGRATE.p("Norm Functions: " + expr);
                expr = expr.integrate(v);
                LambdaINTEGRATE.p("Integrated: " + expr);
                expr = LambdaINTEGRATE.remove_constant(expr, v);
                expr = new TrigInverseExpand().f_exakt(expr);
                return expr;
            }
            catch (JasymcaException jasymcaException2) {
                LambdaINTEGRATE.p("Third Attempt: " + expr);
                expr = e;
                SubstExp se = new SubstExp(v, expr);
                expr = se.f_exakt(expr);
                expr = se.rational(expr);
                LambdaINTEGRATE.p("Rationalized: " + expr);
                expr = expr.integrate(se.t);
                LambdaINTEGRATE.p("Integrated: " + expr);
                expr = se.rat_reverse(expr);
                LambdaINTEGRATE.p("Reverse subst.: " + expr);
                expr = LambdaINTEGRATE.remove_constant(expr, v);
                expr = new TrigInverseExpand().f_exakt(expr);
                expr = LambdaINTEGRATE.remove_constant(expr, v);
                return expr;
            }
        }
    }

    static Algebraic remove_constant(Algebraic expr, Variable x) throws JasymcaException {
        if (!expr.depends(x)) {
            return Zahl.ZERO;
        }
        if (expr instanceof Polynomial) {
            ((Polynomial)expr).a[0] = LambdaINTEGRATE.remove_constant(((Polynomial)expr).a[0], x);
            return expr;
        }
        if (expr instanceof Rational) {
            Polynomial den = ((Rational)expr).den;
            Algebraic nom = ((Rational)expr).nom;
            if (!den.depends(x)) {
                return LambdaINTEGRATE.remove_constant(nom, x).div(den);
            }
            if (nom instanceof Polynomial) {
                Algebraic[] a = new Algebraic[]{nom, den};
                Poly.polydiv(a, den.var);
                if (!a[0].depends(x)) {
                    return a[1].div(den);
                }
            }
        }
        return expr;
    }
}

