/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;
import jhplot.math.num.random.GammaRandomVariable;

class LambdaGAMMA_RND
extends Lambda {
    LambdaGAMMA_RND() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        Algebraic x;
        Algebraic b;
        Algebraic a;
        int narg = LambdaGAMMA_RND.getNarg(st);
        if (narg != 3 && narg != 4) {
            throw new ParseException("requires 3 or 4 arguments. Mean, STD, dimension X and Y");
        }
        if (narg == 4) {
            a = LambdaGAMMA_RND.getAlgebraic(st);
            b = LambdaGAMMA_RND.getAlgebraic(st);
            x = LambdaGAMMA_RND.getAlgebraic(st);
            Algebraic y = LambdaGAMMA_RND.getAlgebraic(st);
            if (a instanceof Zahl && b instanceof Zahl && x instanceof Zahl && y instanceof Zahl) {
                double x1 = ((Zahl)a).unexakt().real;
                double x2 = ((Zahl)b).unexakt().real;
                int j1 = (int)((Zahl)x).unexakt().real;
                int j2 = (int)((Zahl)y).unexakt().real;
                GammaRandomVariable p = new GammaRandomVariable(x1, x2);
                double[][] d = new double[j1][j2];
                for (int i = 0; i < j1; ++i) {
                    for (int j = 0; j < j2; ++j) {
                        d[i][j] = p.nextRandomVariable();
                    }
                }
                Matrix m = new Matrix(d);
                st.push(m);
            }
        }
        if (narg == 3) {
            a = LambdaGAMMA_RND.getAlgebraic(st);
            b = LambdaGAMMA_RND.getAlgebraic(st);
            x = LambdaGAMMA_RND.getAlgebraic(st);
            if (a instanceof Zahl && b instanceof Zahl && x instanceof Zahl) {
                double x1 = ((Zahl)a).unexakt().real;
                double x2 = ((Zahl)b).unexakt().real;
                int j1 = (int)((Zahl)x).unexakt().real;
                GammaRandomVariable p = new GammaRandomVariable(x1, x2);
                double[] d = new double[j1];
                for (int i = 0; i < j1; ++i) {
                    d[i] = p.nextRandomVariable();
                }
                Vektor m = new Vektor(d);
                st.push(m);
            }
        }
        return 0;
    }
}

