/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.ExpandConstants;
import jasymca.JasymcaException;
import jasymca.LambdaAlgebraic;
import jasymca.ParseException;
import jasymca.Unexakt;
import jasymca.Zahl;
import java.util.Stack;

class LambdaFLOAT
extends LambdaAlgebraic {
    double eps = 1.0E-8;

    LambdaFLOAT() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        double epstry;
        int narg = LambdaFLOAT.getNarg(st);
        Algebraic exp = LambdaFLOAT.getAlgebraic(st);
        Zahl a = LambdaFLOAT.pc.env.getnum("algepsilon");
        if (a != null && (epstry = a.unexakt().real) > 0.0) {
            this.eps = epstry;
        }
        exp = new ExpandConstants().f_exakt(exp);
        st.push(exp.map(this));
        return 0;
    }

    @Override
    public Zahl f(Zahl x) throws JasymcaException {
        double i;
        Unexakt f = x.unexakt();
        if (f.equals(Zahl.ZERO)) {
            return f;
        }
        double r = f.real;
        double abs = ((Unexakt)f.abs()).real;
        if (Math.abs(r / abs) < this.eps) {
            r = 0.0;
        }
        if (Math.abs((i = f.imag) / abs) < this.eps) {
            i = 0.0;
        }
        return new Unexakt(r, i);
    }

    @Override
    Algebraic f_exakt(Algebraic x) throws JasymcaException {
        return x.map(this);
    }
}

