/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaRAT;
import jasymca.ParseException;
import jasymca.Poly;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;

class LambdaDIVIDE
extends Lambda {
    LambdaDIVIDE() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        Algebraic p2;
        int size = LambdaDIVIDE.getNarg(st);
        if (size != 3 && size != 2) {
            throw new ParseException("Usage: DIVIDE (p1, p2, var)");
        }
        Algebraic p1 = LambdaDIVIDE.getAlgebraic(st);
        if (!p1.exaktq()) {
            p1 = new LambdaRAT().f_exakt(p1);
        }
        if (!(p2 = LambdaDIVIDE.getAlgebraic(st)).exaktq()) {
            p2 = new LambdaRAT().f_exakt(p2);
        }
        Algebraic[] a = new Algebraic[]{p1, p2};
        if (size == 3) {
            Variable v = LambdaDIVIDE.getVariable(st);
            Poly.polydiv(a, v);
        } else if (p1 instanceof Zahl && p2 instanceof Zahl) {
            a = ((Zahl)p1).div(p2, a);
        } else {
            a[0] = Poly.polydiv(p1, p2);
            a[1] = p1.sub(a[0].mult(p2));
        }
        st.push(new Vektor(a));
        return 0;
    }
}

