/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaRAT;
import jasymca.ParseException;
import jasymca.Polynomial;
import jasymca.Rational;
import jasymca.Variable;
import java.util.Stack;

class LambdaDIFF
extends Lambda {
    LambdaDIFF() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        Variable v;
        int narg = LambdaDIFF.getNarg(st);
        if (narg == 0) {
            throw new ParseException("Argument to diff missing.");
        }
        Algebraic f = LambdaDIFF.getAlgebraic(st);
        if (narg > 1) {
            v = LambdaDIFF.getVariable(st);
        } else if (f instanceof Polynomial) {
            v = ((Polynomial)f).var;
        } else if (f instanceof Rational) {
            v = ((Rational)f).den.var;
        } else {
            throw new ParseException("Could not determine Variable.");
        }
        Algebraic df = f.deriv(v);
        if (df instanceof Rational && !df.exaktq()) {
            df = new LambdaRAT().f_exakt(df);
        }
        st.push(df);
        return 0;
    }
}

