/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.ErrorLogger;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.StringTokenizer;

class LambdaCSVREAD
extends Lambda {
    LambdaCSVREAD() {
    }

    @Override
    public int lambda(Stack st) throws ParseException, JasymcaException {
        int narg = LambdaCSVREAD.getNarg(st);
        if (narg != 1) {
            throw new JasymcaException("Usage: csvread(filename)");
        }
        Object s_in = st.pop();
        if (!(s_in instanceof String)) {
            throw new JasymcaException("First argument to csvread must be string (filename).");
        }
        String filename = (String)s_in;
        filename = filename.trim();
        ErrorLogger.debugLine("Reading CSV>" + filename + "<");
        File CSVFile = new File(filename);
        if (!CSVFile.exists()) {
            throw new JasymcaException("File do not exists or the path is wrong" + filename);
        }
        ArrayList<Double> vec = new ArrayList<Double>();
        ArrayList<double[]> mat = new ArrayList<double[]>();
        boolean isVector = false;
        int lineNumber = 0;
        int colums = 0;
        try {
            String strLine;
            BufferedReader br = new BufferedReader(new FileReader(CSVFile));
            while ((strLine = br.readLine()) != null) {
                if (++lineNumber == 1 && strLine.indexOf(",") == -1) {
                    isVector = true;
                }
                if (isVector) {
                    double dd = Double.parseDouble(strLine);
                    vec.add(dd);
                    continue;
                }
                StringTokenizer sst = new StringTokenizer(strLine, ",");
                colums = sst.countTokens();
                double[] row = new double[colums];
                int nn = 0;
                while (sst.hasMoreTokens()) {
                    String val = sst.nextToken();
                    row[nn] = Double.parseDouble(val);
                    ++nn;
                }
                mat.add(row);
            }
            br.close();
            if (isVector) {
                double[] ret = new double[vec.size()];
                for (int i = 0; i < vec.size(); ++i) {
                    ret[i] = (Double)vec.get(i);
                }
                st.push(new Vektor(ret));
                return 0;
            }
            double[][] d = new double[mat.size()][colums];
            for (int i = 0; i < mat.size(); ++i) {
                double[] cols = (double[])mat.get(i);
                for (int j = 0; j < cols.length; ++j) {
                    d[i][j] = cols[j];
                }
            }
            st.push(new Matrix(d));
            return 0;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }
}

