/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.Constants;
import jasymca.Environment;
import jasymca.ExpandConstants;
import jasymca.JasymcaException;
import jasymca.ParseException;
import jasymca.Parser;
import jasymca.Polynomial;
import jasymca.Processor;
import jasymca.SimpleVariable;
import jasymca.Variable;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.List;
import java.util.Stack;

public abstract class Lambda
implements Constants {
    public static Processor pc;
    public static Parser pr;
    public static final boolean debug = false;
    protected static int length;
    public static Environment sandbox;

    protected static void p(String s) {
    }

    protected int lambda(Stack x) throws ParseException, JasymcaException {
        return 0;
    }

    public static Algebraic getAlgebraic(Stack st) throws ParseException, JasymcaException {
        Object arg_in = st.pop();
        if (!(arg_in instanceof Algebraic)) {
            pc.process_instruction(arg_in, true);
            arg_in = st.pop();
        }
        if (!(arg_in instanceof Algebraic)) {
            throw new JasymcaException("Expected algebraic, got: " + arg_in);
        }
        return (Algebraic)arg_in;
    }

    public static Zahl getNumber(Stack st) throws ParseException, JasymcaException {
        Object arg = st.pop();
        if (arg instanceof Algebraic) {
            arg = new ExpandConstants().f_exakt((Algebraic)arg);
        }
        if (!(arg instanceof Zahl)) {
            throw new ParseException("Expected number, got " + arg);
        }
        return (Zahl)arg;
    }

    public static int getNarg(Stack st) throws ParseException, JasymcaException {
        Object arg_in = st.pop();
        if (!(arg_in instanceof Integer)) {
            throw new JasymcaException("Expected Integer, got: " + arg_in);
        }
        return (Integer)arg_in;
    }

    public static String getSymbol(Stack st) throws ParseException, JasymcaException {
        Object arg_in = st.pop();
        if (!(arg_in instanceof String) || ((String)arg_in).length() == 0 || ((String)arg_in).charAt(0) == ' ') {
            throw new JasymcaException("Expected Symbol, got: " + arg_in);
        }
        return (String)arg_in;
    }

    public static Polynomial getPolynomial(Stack st) throws ParseException, JasymcaException {
        Algebraic arg = Lambda.getAlgebraic(st);
        if (!(arg instanceof Polynomial)) {
            throw new ParseException("Expected polynomial, got " + arg);
        }
        return (Polynomial)arg;
    }

    public static Vektor getVektor(Stack st) throws ParseException, JasymcaException {
        Object arg = st.pop();
        if (!(arg instanceof Vektor)) {
            throw new ParseException("Expected vector, got " + arg);
        }
        return (Vektor)arg;
    }

    public static Variable getVariable(Stack st) throws ParseException, JasymcaException {
        Polynomial p = Lambda.getPolynomial(st);
        return p.var;
    }

    public static int getInteger(Stack st) throws ParseException, JasymcaException {
        Object arg = st.pop();
        if (!(arg instanceof Zahl) || !((Zahl)arg).integerq()) {
            throw new ParseException("Expected integer, got " + arg);
        }
        return ((Zahl)arg).intval();
    }

    public static int getInteger(Algebraic arg) throws ParseException, JasymcaException {
        if (!(arg instanceof Zahl) || !((Zahl)arg).integerq()) {
            throw new ParseException("Expected integer, got " + arg);
        }
        return ((Zahl)arg).intval();
    }

    public static List getList(Stack st) throws ParseException, JasymcaException {
        Object arg = st.pop();
        if (!(arg instanceof List)) {
            throw new ParseException("Expected list, got " + arg);
        }
        return (List)arg;
    }

    public static Zahl ensure_Zahl(Object x) throws JasymcaException {
        if (!(x instanceof Zahl)) {
            throw new JasymcaException("Expected number, got " + x);
        }
        return (Zahl)x;
    }

    public static Algebraic evalx(String rule, Algebraic x) throws JasymcaException {
        try {
            List pgm = pr.compile(rule);
            Environment global = pc.getEnvironment();
            if (sandbox == null) {
                sandbox = new Environment();
                sandbox.putValue("x", new Polynomial(new SimpleVariable("x")));
                sandbox.putValue("X", new Polynomial(new SimpleVariable("X")));
                sandbox.putValue("a", new Polynomial(new SimpleVariable("a")));
                sandbox.putValue("b", new Polynomial(new SimpleVariable("b")));
                sandbox.putValue("c", new Polynomial(new SimpleVariable("c")));
            }
            pc.setEnvironment(sandbox);
            pc.process_list(pgm, true);
            pc.setEnvironment(global);
            Algebraic y = Lambda.getAlgebraic(Lambda.pc.stack);
            y = y.value(new SimpleVariable("x"), x);
            return y;
        }
        catch (Exception e) {
            throw new JasymcaException("Could not evaluate expression " + rule + ": " + e.toString());
        }
    }

    static {
        length = 1;
        sandbox = null;
    }
}

