/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.Matrix;
import jasymca.ParseException;
import jasymca.Vektor;
import jasymca.Zahl;
import java.util.Stack;

class Index {
    int[] row;
    int[] col;
    int row_max;
    int col_max;

    public Index(int[] row, int[] col) {
        this.row = row;
        this.col = col;
        this.row_max = this.maxint(row);
        this.col_max = this.maxint(col);
    }

    public Index(int row, int col, Algebraic x) {
        int width = 1;
        int height = 1;
        if (x instanceof Vektor) {
            width = ((Vektor)x).length();
        } else if (x instanceof Matrix) {
            width = ((Matrix)x).nrow();
            height = ((Matrix)x).ncol();
        }
        this.row = Index.series(row, row + height - 1);
        this.col = Index.series(col, col + width - 1);
        this.row_max = this.maxint(this.row);
        this.col_max = this.maxint(this.col);
    }

    private int maxint(int[] c) {
        int max = c[0];
        for (int i = 1; i < c.length; ++i) {
            if (c[i] <= max) continue;
            max = c[i];
        }
        return max;
    }

    public String toString() {
        String s = "Index = \nRows: ";
        for (int i = 0; i < this.row.length; ++i) {
            s = s + "  " + this.row[i];
        }
        s = s + "\nColumns: ";
        for (int k = 0; k < this.col.length; ++k) {
            s = s + "  " + this.col[k];
        }
        return s;
    }

    public static Index createIndex(Algebraic idx_in, Matrix x) throws JasymcaException {
        if (!idx_in.constantq()) {
            throw new JasymcaException("Index not constant: " + idx_in);
        }
        if ((idx_in = idx_in.reduce()) instanceof Zahl && ((Zahl)idx_in).integerq()) {
            int[] row = new int[]{1};
            int[] col = new int[]{((Zahl)idx_in).intval()};
            return new Index(row, col);
        }
        if (idx_in instanceof Vektor && ((Vektor)idx_in).length() == 2) {
            Algebraic r = ((Vektor)idx_in).get(0);
            Algebraic c = ((Vektor)idx_in).get(1);
            if (r instanceof Zahl && ((Zahl)r).integerq() && c instanceof Zahl && ((Zahl)c).integerq()) {
                int[] row = new int[]{((Zahl)r).intval()};
                int[] col = new int[]{((Zahl)c).intval()};
                return new Index(row, col);
            }
        }
        throw new JasymcaException("Not a legel index: " + idx_in);
    }

    public static Index createIndex(Stack st, Matrix x) throws ParseException, JasymcaException {
        Object cdx;
        int[] row;
        int length = Lambda.getNarg(st);
        if (length > 1) {
            Object rdx = st.pop();
            row = ":".equals(rdx) ? Index.series(1, x.nrow()) : Index.setseries((Algebraic)rdx);
            cdx = st.pop();
        } else {
            cdx = st.pop();
            row = new int[]{1};
        }
        int[] col = ":".equals(cdx) ? Index.series(1, x.ncol()) : Index.setseries((Algebraic)cdx);
        return new Index(row, col);
    }

    static int[] setseries(Algebraic c) throws ParseException, JasymcaException {
        int[] s;
        if (c instanceof Zahl && ((Zahl)c).integerq()) {
            s = new int[]{((Zahl)c).intval()};
        } else if (c instanceof Vektor) {
            s = new int[((Vektor)c).length()];
            for (int i = 0; i < s.length; ++i) {
                Algebraic a = ((Vektor)c).get(i);
                if (!(a instanceof Zahl) || !((Zahl)a).integerq()) {
                    throw new ParseException("Not a legal index: " + a);
                }
                s[i] = ((Zahl)a).intval();
            }
        } else {
            throw new ParseException("Not a legal index: " + c);
        }
        return s;
    }

    static int[] series(int a, int b) {
        int[] c = new int[b + 1 - a];
        for (int i = 0; i < c.length; ++i) {
            c[i] = a + i;
        }
        return c;
    }
}

