/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import jasymca.Algebraic;
import jasymca.JasymcaException;
import jasymca.Lambda;
import jasymca.LambdaAlgebraic;
import jasymca.Polynomial;
import jasymca.SimpleVariable;
import jasymca.Unexakt;
import jasymca.Variable;
import jasymca.Zahl;

public class FunctionVariable
extends Variable {
    public String fname;
    public Algebraic arg;
    public LambdaAlgebraic la;

    public FunctionVariable(String fname, Algebraic arg, LambdaAlgebraic la) {
        this.fname = fname;
        this.arg = arg;
        this.la = la;
    }

    @Override
    public Algebraic deriv(Variable x) throws JasymcaException {
        if (this.equals(x)) {
            return Zahl.ONE;
        }
        if (!this.arg.depends(x)) {
            return Zahl.ZERO;
        }
        if (this.la == null) {
            throw new JasymcaException("Can not differentiate " + this.fname + "  : No definition.");
        }
        String diffrule = this.la.diffrule;
        if (diffrule == null) {
            throw new JasymcaException("Can not differentiate " + this.fname + " : No rule available.");
        }
        Algebraic y = Lambda.evalx(diffrule, this.arg);
        return y.mult(this.arg.deriv(x));
    }

    public Algebraic integrate(Variable x) throws JasymcaException {
        this.arg = this.arg.reduce();
        if (this.la == null) {
            throw new JasymcaException("Can not integrate " + this.fname);
        }
        return this.la.integrate(this.arg, x);
    }

    public static Algebraic create(String f, Algebraic arg) throws JasymcaException {
        arg = arg.reduce();
        Object fl = Lambda.pc.env.getValue(f);
        if (fl != null && fl instanceof LambdaAlgebraic) {
            Algebraic r = ((LambdaAlgebraic)fl).f_exakt(arg);
            if (r != null) {
                return r;
            }
            if (arg instanceof Unexakt) {
                return ((LambdaAlgebraic)fl).f((Zahl)arg);
            }
        } else {
            fl = null;
        }
        return new Polynomial(new FunctionVariable(f, arg, (LambdaAlgebraic)fl));
    }

    @Override
    public boolean equals(Object x) {
        return x instanceof FunctionVariable && this.fname.equals(((FunctionVariable)x).fname) && this.arg.equals(((FunctionVariable)x).arg);
    }

    @Override
    public Algebraic value(Variable var, Algebraic x) throws JasymcaException {
        if (this.equals(var)) {
            return x;
        }
        Algebraic r = this.la.f_exakt(x = this.arg.value(var, x));
        if (r != null) {
            return r;
        }
        if (x instanceof Unexakt) {
            return this.la.f((Zahl)x);
        }
        return new Polynomial(new FunctionVariable(this.fname, x, this.la));
    }

    @Override
    public boolean smaller(Variable v) throws JasymcaException {
        if (v == SimpleVariable.top) {
            return true;
        }
        if (v instanceof SimpleVariable) {
            return false;
        }
        if (!((FunctionVariable)v).fname.equals(this.fname)) {
            return this.fname.compareTo(((FunctionVariable)v).fname) < 0;
        }
        if (this.arg.equals(((FunctionVariable)v).arg)) {
            return false;
        }
        if (this.arg instanceof Polynomial && ((FunctionVariable)v).arg instanceof Polynomial) {
            Polynomial a = (Polynomial)this.arg;
            Polynomial b = (Polynomial)((FunctionVariable)v).arg;
            if (!a.var.equals(b.var)) {
                return a.var.smaller(b.var);
            }
            if (a.degree() != b.degree()) {
                return a.degree() < b.degree();
            }
            for (int i = a.a.length - 1; i >= 0; --i) {
                if (a.a[i].equals(b.a[i])) continue;
                if (a.a[i] instanceof Zahl && b.a[i] instanceof Zahl) {
                    return ((Zahl)a.a[i]).smaller((Zahl)b.a[i]);
                }
                return a.a[i].norm() < b.a[i].norm();
            }
        }
        return false;
    }

    @Override
    public Variable cc() throws JasymcaException {
        if (this.fname.equals("exp") || this.fname.equals("log") || this.fname.equals("sqrt")) {
            return new FunctionVariable(this.fname, this.arg.cc(), this.la);
        }
        throw new JasymcaException("Can't calculate cc for Function " + this.fname);
    }

    public String toString() {
        String a = this.arg.toString();
        if (a.startsWith("(") && a.endsWith(")")) {
            return this.fname + a;
        }
        return this.fname + "(" + a + ")";
    }
}

