/*
 * Decompiled with CFR 0.152.
 */
package jasymca;

import java.io.IOException;
import java.io.RandomAccessFile;

public class ErrorLogger {
    private static String indentS = "";
    private static boolean debugB = false;
    private static RandomAccessFile output = null;

    public static boolean getDebug() {
        return debugB;
    }

    public static void setDebug(boolean _debug) {
        debugB = _debug;
    }

    public static void debugLine(String text) {
        if (debugB) {
            try {
                if (output == null) {
                    System.out.println("ERROR LOGGER: OPENING FILE");
                    output = new RandomAccessFile("jmathlab.log", "rw");
                    output.seek(output.length());
                }
                output.writeBytes(indentS + text + "\n");
            }
            catch (IOException error) {
                System.out.println("ERROR LOGGER: IOException");
            }
            catch (SecurityException error) {
                System.out.println("ERROR LOGGER: SecurityException");
            }
            System.out.println(indentS + text);
        }
    }

    public void finalize() throws Throwable {
        try {
            System.out.println("ERROR LOGGER FINALIZE");
            output.close();
        }
        finally {
            super.finalize();
        }
    }

    public static void debugLine(int value) {
        ErrorLogger.debugLine(new Integer(value).toString());
    }

    public static void debugLine(double value) {
        ErrorLogger.debugLine(new Double(value).toString());
    }

    public static void increaseIndent() {
        indentS = indentS + " ";
    }

    public static void decreaseIndent() {
        if (indentS.length() == 0) {
            return;
        }
        indentS = indentS.substring(0, indentS.length() - 1);
    }

    public static void displayStackTrace(String message) {
        new Exception(message).printStackTrace();
    }
}

