/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.random;

import java.util.List;
import org.neuroph.core.Connection;
import org.neuroph.core.Layer;
import org.neuroph.core.NeuralNetwork;
import org.neuroph.core.Neuron;
import org.neuroph.util.random.RangeRandomizer;

public class NguyenWidrowRandomizer
extends RangeRandomizer {
    public NguyenWidrowRandomizer(double min, double max) {
        super(min, max);
    }

    public void randomize(NeuralNetwork neuralNetwork) {
        super.randomize(neuralNetwork);
        int inputNeuronsCount = neuralNetwork.getInputNeurons().size();
        int hiddenNeuronsCount = 0;
        for (int i = 1; i < neuralNetwork.getLayersCount() - 1; ++i) {
            hiddenNeuronsCount += neuralNetwork.getLayerAt(i).getNeuronsCount();
        }
        double beta = 0.7 * Math.pow(hiddenNeuronsCount, 1.0 / (double)inputNeuronsCount);
        List<Layer> layers = neuralNetwork.getLayers();
        for (Layer layer : layers) {
            double weight;
            double norm = 0.0;
            for (Neuron neuron : layer.getNeurons()) {
                for (Connection connection : neuron.getInputConnections()) {
                    weight = connection.getWeight().getValue();
                    norm += weight * weight;
                }
            }
            norm = Math.sqrt(norm);
            for (Neuron neuron : layer.getNeurons()) {
                for (Connection connection : neuron.getInputConnections()) {
                    weight = connection.getWeight().getValue();
                    weight = beta * weight / norm;
                    connection.getWeight().setValue(weight);
                }
            }
        }
    }
}

