/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.random;

import org.neuroph.util.random.WeightsRandomizer;

public class GaussianRandomizer
extends WeightsRandomizer {
    double mean;
    double standardDeviation;
    private double y2;
    private boolean useLast = false;

    public GaussianRandomizer(double mean, double standardDeviation) {
        this.mean = mean;
        this.standardDeviation = standardDeviation;
    }

    private double boxMuller(double mean, double std) {
        double y1;
        if (this.useLast) {
            y1 = this.y2;
            this.useLast = false;
        } else {
            double x2;
            double x1;
            double w;
            while ((w = (x1 = 2.0 * this.randomGen.nextDouble() - 1.0) * x1 + (x2 = 2.0 * this.randomGen.nextDouble() - 1.0) * x2) >= 1.0) {
            }
            w = Math.sqrt(-2.0 * Math.log(w) / w);
            y1 = x1 * w;
            this.y2 = x2 * w;
            this.useLast = true;
        }
        return mean + y1 * std;
    }

    @Override
    protected double nextRandomWeight() {
        return this.boxMuller(this.mean, this.standardDeviation);
    }
}

