/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.random;

import org.neuroph.core.Connection;
import org.neuroph.core.Neuron;
import org.neuroph.util.random.WeightsRandomizer;

public class DistortRandomizer
extends WeightsRandomizer {
    double distortionFactor;

    public DistortRandomizer(double distortionFactor) {
        this.distortionFactor = distortionFactor;
    }

    @Override
    protected void randomize(Neuron neuron) {
        for (Connection connection : neuron.getInputConnections()) {
            double weight = connection.getWeight().getValue();
            connection.getWeight().setValue(this.distort(weight));
        }
    }

    private double distort(double weight) {
        return weight + (this.distortionFactor - this.randomGen.nextDouble() * this.distortionFactor * 2.0);
    }
}

