/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util.data.norm;

import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.DataSetStats;
import org.neuroph.util.data.norm.Normalizer;

public class ZeroMeanNormalizer
implements Normalizer {
    @Override
    public void normalize(DataSet dataSet) {
        double[] maxInput = DataSetStats.calculateMaxByColumns(dataSet);
        double[] minInput = DataSetStats.calculateMinByColumns(dataSet);
        double[] meanInput = DataSetStats.calculateMeanByColumns(dataSet);
        for (DataSetRow row : dataSet.getRows()) {
            double[] normalizedInput = row.getInput();
            for (int i = 0; i < dataSet.getInputSize(); ++i) {
                double divider = maxInput[i] - minInput[i] == 0.0 ? 1.0 : maxInput[i] - minInput[i];
                normalizedInput[i] = (normalizedInput[i] - meanInput[i]) / divider;
            }
            row.setInput(normalizedInput);
        }
    }
}

