/*
 * Decompiled with CFR 0.152.
 */
package org.neuroph.util;

import org.neuroph.core.data.DataSet;
import org.neuroph.core.data.DataSetRow;
import org.neuroph.util.DataSetColumnType;

public class DataSetStatistics {
    private final int rowSize;
    private final int rowCount;
    private final double[] mean;
    private final double[] max;
    private final double[] min;
    private final double[] sum;
    private final double[] var;
    private final double[] stdDev;
    private final double[] frequency;
    private final DataSet dataSet;
    public static final String MIN = "min";
    public static final String MAX = "max";
    public static final String MEAN = "mean";
    public static final String SUM = "sum";
    public static final String STD_DEV = "std dev";
    public static final String VAR = "var";
    public static final String FREQ = "freq";

    public DataSetStatistics(DataSet dataSet) {
        this.dataSet = dataSet;
        this.rowSize = dataSet.getInputSize() + dataSet.getOutputSize();
        this.rowCount = dataSet.getRows().size();
        this.mean = new double[this.rowSize];
        this.max = new double[this.rowSize];
        this.min = new double[this.rowSize];
        this.sum = new double[this.rowSize];
        this.var = new double[this.rowSize];
        this.stdDev = new double[this.rowSize];
        this.frequency = new double[this.rowSize];
        this.setDefaultValues();
    }

    private void setDefaultValues() {
        for (int i = 0; i < this.rowSize; ++i) {
            this.max[i] = -1.7976931348623157E308;
            this.min[i] = Double.MAX_VALUE;
        }
    }

    private void resetValues() {
        for (int i = 0; i < this.rowSize; ++i) {
            this.sum[i] = 0.0;
            this.var[i] = 0.0;
            this.frequency[i] = -0.0;
        }
    }

    public void calculateStatistics() {
        int i;
        double[] row;
        this.resetValues();
        DataSetColumnType[] columnTypes = this.dataSet.getColumnTypes();
        for (DataSetRow dataSetRow : this.dataSet.getRows()) {
            row = dataSetRow.toArray();
            for (i = 0; i < this.rowSize; ++i) {
                this.max[i] = Math.max(this.max[i], row[i]);
                this.min[i] = Math.min(this.min[i], row[i]);
                int n = i;
                this.sum[n] = this.sum[n] + row[i];
                if (columnTypes[i] != DataSetColumnType.NOMINAL) continue;
                int n2 = i;
                this.frequency[n2] = this.frequency[n2] + row[i];
            }
        }
        for (int i2 = 0; i2 < this.rowSize; ++i2) {
            this.mean[i2] = this.sum[i2] / (double)this.rowCount;
            if (columnTypes[i2] != DataSetColumnType.NOMINAL) continue;
            int n = i2;
            this.frequency[n] = this.frequency[n] / (double)this.rowCount;
        }
        for (DataSetRow dataSetRow : this.dataSet.getRows()) {
            row = dataSetRow.toArray();
            i = 0;
            while (i < this.rowSize) {
                double delta = row[i] - this.mean[i];
                int n = i++;
                this.var[n] = this.var[n] + delta * delta;
            }
        }
        for (int i3 = 0; i3 < this.rowSize; ++i3) {
            int n = i3;
            this.var[n] = this.var[n] / (double)this.rowCount;
            this.stdDev[i3] = Math.sqrt(this.var[i3]);
        }
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public double[] getMean() {
        return this.mean;
    }

    public double[] getMax() {
        return this.max;
    }

    public double[] getMin() {
        return this.min;
    }

    public double[] getVar() {
        return this.var;
    }

    public double[] getStdDev() {
        return this.stdDev;
    }

    public double[] getFrequency() {
        return this.frequency;
    }
}

